/*
 * Decompiled with CFR 0.152.
 */
package com.cappuccinonet.strutscx.xslt;

import com.cappuccinonet.strutscx.exceptions.StrutsCXXSLTException;
import com.cappuccinonet.strutscx.xslt.StrutsCXBeanToElement;
import com.cappuccinonet.strutscx.xslt.StrutsCXDocumentBuilder;
import com.cappuccinonet.strutscx.xslt.StrutsCXXSLTUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.ModuleConfig;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.DOMWriter;
import org.jdom.Comment;
import org.jdom.Element;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.input.DOMBuilder;

public class StrutsCXClassicDocumentBuilder
implements StrutsCXDocumentBuilder {
    protected Log logger = LogFactory.getLog(this.getClass());

    public Object createDocument(HttpServletRequest request, HttpSession session, ServletConfig servlet) throws StrutsCXXSLTException {
        this.logger.debug((Object)"---------------------------- BUILD OF DOCUMENT STARTED");
        org.jdom.Document document = new org.jdom.Document();
        String _xsl_clientside = request.getParameter("xsl_clientside");
        boolean xsl_clientside = new Boolean(_xsl_clientside);
        request.setAttribute("xsl_clientside", (Object)("" + xsl_clientside));
        this.logger.debug((Object)("xsl_clientside is set to: " + xsl_clientside));
        if (xsl_clientside) {
            String xslFile = new StrutsCXXSLTUtil().getStylesheet(request, servlet);
            String httpDomain = "http://" + request.getServerName() + ":" + new Integer(request.getServerPort()).toString();
            String projectName = servlet.getServletContext().getServletContextName();
            this.logger.debug((Object)("XSL file added in PI: " + httpDomain + projectName + xslFile));
            Hashtable<String, String> map = new Hashtable<String, String>();
            map.put("type", "text/xsl");
            map.put("href", String.valueOf(httpDomain) + projectName + xslFile);
            ProcessingInstruction pi = new ProcessingInstruction("xml-stylesheet", map);
            document.addContent(pi);
        }
        Element rootElement = new Element("root");
        document.setRootElement(rootElement);
        this.logger.debug((Object)("Created root element: " + rootElement.getName()));
        try {
            Element xmlDataElement = this.getDataSourceElement(request);
            Comment xmlDataComment = new Comment("********** XML DATA **********");
            rootElement.addContent(xmlDataComment);
            rootElement.addContent(xmlDataElement);
            Element variablesElement = this.getRessourcePropertiesElement(session, servlet);
            Comment variablesComment = new Comment("********** RESSOURCEN-PROPERTIES  **********");
            rootElement.addContent(variablesComment);
            rootElement.addContent(variablesElement);
            Element actionformElement = this.getActionFormElement(request);
            Comment actionformComment = new Comment("********** ACTIONFORM PARAMETERS **********");
            rootElement.addContent(actionformComment);
            rootElement.addContent(actionformElement);
            Element errorElement = this.getErrorElement(request);
            Comment errorComment = new Comment("********** ERROR PARAMETERS **********");
            rootElement.addContent(errorComment);
            rootElement.addContent(errorElement);
            Element requestElement = this.getRequestElement(request);
            Comment requestComment = new Comment("********** REQUEST PARAMETERS **********");
            rootElement.addContent(requestComment);
            if (requestElement != null) {
                rootElement.addContent(requestElement);
            }
            Element sessionElement = this.getSessionElement(request, session);
            Comment sessionComment = new Comment("********** SESSION PARAMETERS **********");
            rootElement.addContent(sessionComment);
            if (sessionElement != null) {
                rootElement.addContent(sessionElement);
            }
            this.logger.debug((Object)"Document created");
        }
        catch (StrutsCXXSLTException sce) {
            this.logger.error((Object)"StrutsCXXSLTException");
            throw new StrutsCXXSLTException(sce.toString());
        }
        this.logger.debug((Object)"---------------------------- BUILD OF DOCUMENT DONE");
        return document;
    }

    private Element getDataSourceElement(HttpServletRequest request) throws StrutsCXXSLTException {
        Object object = request.getAttribute("xml_key");
        Element root = null;
        if (object instanceof ArrayList) {
            root = new Element("data");
            ArrayList valueObjects = (ArrayList)object;
            Iterator iter = valueObjects.iterator();
            StrutsCXBeanToElement bte = new StrutsCXBeanToElement();
            while (iter.hasNext()) {
                Object thisValueObject = iter.next();
                Element content = bte.getBeanContent(thisValueObject);
                root.addContent(content);
            }
        } else if (object instanceof org.jdom.Document) {
            org.jdom.Document xmlFileDoc = (org.jdom.Document)object;
            if (xmlFileDoc == null) {
                throw new StrutsCXXSLTException("Please provide the XML data source!");
            }
            root = (Element)xmlFileDoc.getRootElement().clone();
            if (root == null) {
                throw new StrutsCXXSLTException("Please check the XML data source");
            }
        } else if (object instanceof org.w3c.dom.Document) {
            org.w3c.dom.Document xmlFileDoc_ = (org.w3c.dom.Document)object;
            if (xmlFileDoc_ == null) {
                throw new StrutsCXXSLTException("Please provide the XML data source!");
            }
            org.jdom.Document xmlFileDoc = new DOMBuilder().build(xmlFileDoc_);
            root = (Element)xmlFileDoc.getRootElement().clone();
            if (root == null) {
                throw new StrutsCXXSLTException("Please check the XML data source");
            }
        } else if (object instanceof Document) {
            Document xmlFileDoc_ = (Document)object;
            if (xmlFileDoc_ == null) {
                throw new StrutsCXXSLTException("Please provide the XML data source!");
            }
            DOMWriter writer = new DOMWriter();
            org.w3c.dom.Document domDocument = null;
            try {
                domDocument = writer.write(xmlFileDoc_);
            }
            catch (DocumentException e) {
                this.logger.error((Object)"DocumentException during converting dom4j Document to org.w3c.dom.DOM");
            }
            org.jdom.Document xmlFileDoc = new DOMBuilder().build(domDocument);
            root = (Element)xmlFileDoc.getRootElement().clone();
            if (root == null) {
                throw new StrutsCXXSLTException("Please check the XML data source");
            }
        }
        return root;
    }

    private Element getRessourcePropertiesElement(HttpSession session, ServletConfig config) throws StrutsCXXSLTException {
        String locale = (String)session.getAttribute("locale");
        String variablesFileName = "com.cappuccinonet.strutscx.ressourceproperties_files." + locale.trim();
        org.jdom.Document variablesFile = (org.jdom.Document)config.getServletContext().getAttribute(variablesFileName);
        Element variablesElement = null;
        if (variablesFile == null) {
            variablesElement = new Element("variables");
            this.logger.debug((Object)"no variables_xx.xml provided!!");
        } else {
            if (variablesFile instanceof org.jdom.Document) {
                org.jdom.Document xmlFileDoc = variablesFile;
                if (xmlFileDoc == null) {
                    throw new StrutsCXXSLTException("Please provide the XML data source!");
                }
                variablesElement = (Element)xmlFileDoc.getRootElement().clone();
                if (variablesElement == null) {
                    throw new StrutsCXXSLTException("Please check the XML data source");
                }
            } else if (variablesFile instanceof org.w3c.dom.Document) {
                org.w3c.dom.Document xmlFileDoc_ = (org.w3c.dom.Document)variablesFile;
                if (xmlFileDoc_ == null) {
                    throw new StrutsCXXSLTException("Please provide the XML data source!");
                }
                org.jdom.Document xmlFileDoc = new DOMBuilder().build(xmlFileDoc_);
                variablesElement = (Element)xmlFileDoc.getRootElement().clone();
                if (variablesElement == null) {
                    throw new StrutsCXXSLTException("Please check the XML data source");
                }
            } else if (variablesFile instanceof Document) {
                Document xmlFileDoc_ = (Document)variablesFile;
                if (xmlFileDoc_ == null) {
                    throw new StrutsCXXSLTException("Please provide the XML data source!");
                }
                DOMWriter writer = new DOMWriter();
                org.w3c.dom.Document domDocument = null;
                try {
                    domDocument = writer.write(xmlFileDoc_);
                }
                catch (DocumentException e) {
                    this.logger.error((Object)"DocumentException during converting dom4j Document to org.w3c.dom.DOM");
                }
                org.jdom.Document xmlFileDoc = new DOMBuilder().build(domDocument);
                variablesElement = (Element)xmlFileDoc.getRootElement().clone();
                if (variablesElement == null) {
                    throw new StrutsCXXSLTException("Please check the XML data source");
                }
            }
            this.logger.debug((Object)("Received Document form variablesFileName: " + variablesFileName));
            if (variablesFile.getRootElement() == null || variablesElement == null) {
                throw new StrutsCXXSLTException("Please check the content of the variables file!");
            }
        }
        return variablesElement;
    }

    private Element getActionFormElement(HttpServletRequest request) throws StrutsCXXSLTException {
        Element actionformElement = new Element("actionform");
        try {
            if (request.getAttribute("currentForm") != null) {
                ActionForm form = (ActionForm)request.getAttribute("currentForm");
                StrutsCXBeanToElement bte = new StrutsCXBeanToElement();
                Element attr = bte.getBeanContent(form);
                actionformElement.addContent(attr);
            } else {
                this.logger.debug((Object)"The ActionForm parameter is null: No ActionFrom Element will be created!");
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception");
            e.printStackTrace();
        }
        this.logger.debug((Object)"ActionForm Element created");
        return actionformElement;
    }

    private Element getErrorElement(HttpServletRequest request) throws StrutsCXXSLTException {
        Element errorElement = new Element("errors");
        try {
            if (request.getAttribute("errors") != null) {
                ActionErrors errors = (ActionErrors)request.getAttribute("errors");
                if (!errors.isEmpty()) {
                    Iterator iter = errors.properties();
                    while (iter.hasNext()) {
                        String property = iter.next().toString();
                        Element error = new Element(property);
                        errorElement.addContent(error);
                    }
                }
            } else {
                this.logger.debug((Object)"The Error parameter is null: No Error Element will be created!");
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception");
            e.printStackTrace();
        }
        this.logger.debug((Object)"Error Element created");
        return errorElement;
    }

    private Element getRequestElement(HttpServletRequest request) throws StrutsCXXSLTException {
        Element requestElement = new Element("request");
        long timer = 0L;
        Comment requestAttributesComment = new Comment("Attributes");
        requestElement.addContent(requestAttributesComment);
        Enumeration attributesEnum = request.getAttributeNames();
        while (attributesEnum.hasMoreElements()) {
            String name = (String)attributesEnum.nextElement();
            Object value = request.getAttribute(name);
            if (value instanceof ArrayList | value instanceof ActionMapping | value instanceof ActionErrors | value instanceof ActionForm | value instanceof org.jdom.Document | value instanceof ModuleConfig | value instanceof Document | value instanceof org.w3c.dom.Document) continue;
            this.logger.debug((Object)("CONSTRUCT request Attr: " + name + " = " + value));
            timer = System.currentTimeMillis();
            Element attr = new Element(name);
            Text attrText = value != null ? new Text(value.toString()) : new Text("");
            attr.addContent(attrText);
            requestElement.addContent(attr);
        }
        Comment requestParametersComment = new Comment("Parameters");
        requestElement.addContent(requestParametersComment);
        Enumeration parametersEnum = request.getParameterNames();
        while (parametersEnum.hasMoreElements()) {
            String name = (String)parametersEnum.nextElement();
            String[] values = request.getParameterValues(name);
            int i = 0;
            while (i < values.length) {
                String value = values[i];
                this.logger.debug((Object)("CONSTRUCT request Parameter: " + name + " = " + value));
                timer = System.currentTimeMillis();
                Element attr = new Element(name);
                Text attrText = value != null ? new Text(value.toString()) : new Text("");
                attr.addContent(attrText);
                requestElement.addContent(attr);
                ++i;
            }
        }
        this.logger.debug((Object)"Request element created");
        return requestElement;
    }

    private Element getSessionElement(HttpServletRequest request, HttpSession session) throws StrutsCXXSLTException {
        Element sessionElement = new Element("session");
        Element sessionID = new Element("jsessionid");
        Text sessionString = new Text(session.getId());
        sessionID.addContent(sessionString);
        sessionElement.addContent(sessionID);
        this.logger.debug((Object)("jsessionid is: " + session.getId()));
        Enumeration e = request.getSession().getAttributeNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Object thisValueObject = request.getSession().getAttribute(name);
            Element attr = new Element(name);
            Text attrText = null;
            if (thisValueObject != null) {
                if (thisValueObject instanceof Date) {
                    StrutsCXBeanToElement bte = new StrutsCXBeanToElement();
                    attr = bte.getDateTree((Date)thisValueObject, name);
                    sessionElement.addContent(attr);
                    continue;
                }
                if (thisValueObject instanceof Locale) {
                    Element locale = new Element("locale");
                    Text locale_ = new Text(String.valueOf(((Locale)thisValueObject).getLanguage()) + "_" + ((Locale)thisValueObject).getCountry());
                    locale.addContent(locale_);
                    Element language = new Element("language");
                    Text language_ = new Text(((Locale)thisValueObject).getLanguage());
                    language.addContent(language_);
                    Element country = new Element("country");
                    Text country_ = new Text(((Locale)thisValueObject).getCountry());
                    country.addContent(country_);
                    sessionElement.addContent(locale);
                    sessionElement.addContent(language);
                    sessionElement.addContent(country);
                    continue;
                }
                attrText = new Text(thisValueObject.toString());
                attr.addContent(attrText);
                sessionElement.addContent(attr);
                continue;
            }
            attrText = new Text("");
            attr.addContent(attrText);
            sessionElement.addContent(attr);
        }
        this.logger.debug((Object)"Session element created");
        return sessionElement;
    }
}

