/*
 * Decompiled with CFR 0.152.
 */
package com.cappuccinonet.strutscx.xslt;

import com.cappuccinonet.strutscx.exceptions.StrutsCXXSLTException;
import com.cappuccinonet.strutscx.xslt.StrutsCXTransformer;
import com.cappuccinonet.strutscx.xslt.StrutsCXURIResolver;
import com.cappuccinonet.strutscx.xslt.StrutsCXXSLTUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;
import org.jdom.transform.JDOMResult;
import org.jdom.transform.JDOMSource;

public class StrutsCXStandardTransformer
implements StrutsCXTransformer {
    protected Log logger = LogFactory.getLog(this.getClass());
    private Document pipedDocument = null;

    public void transform(HttpServletRequest request, HttpServletResponse response, HttpSession session, ServletConfig servlet, Object doc, boolean debug) throws StrutsCXXSLTException {
        this.logger.debug((Object)"------------------------------------------- TRANSFORM XML STARTED");
        String encoding = this.extractEncoding(request);
        if (debug) {
            Document document = null;
            if (doc instanceof Document) {
                document = (Document)doc;
                this.logger.debug((Object)"deal with an JDOM Document!");
            } else {
                this.logger.error((Object)"did not get an JDOM Document!!");
            }
            this.takeAction(request, response, session, servlet, document, encoding, debug);
        } else if (request.getParameter("fop") != null && request.getParameter("fop").compareTo("true") == 0 || request.getAttribute("fop") != null && ((String)request.getAttribute("fop")).compareTo("true") == 0 || request.getParameter("foppdf") != null && request.getParameter("foppdf").compareTo("true") == 0 || request.getAttribute("foppdf") != null && ((String)request.getAttribute("foppdf")).compareTo("true") == 0 || request.getParameter("fopsvg") != null && request.getParameter("fopsvg").compareTo("true") == 0 || request.getAttribute("fopsvg") != null && ((String)request.getAttribute("fopsvg")).compareTo("true") == 0 || request.getParameter("fopawt") != null && request.getParameter("fopawt").compareTo("true") == 0 || request.getAttribute("fopawt") != null && ((String)request.getAttribute("fopawt")).compareTo("true") == 0 || request.getParameter("fopprint") != null && request.getParameter("fopprint").compareTo("true") == 0 || request.getAttribute("fopprint") != null && ((String)request.getAttribute("fopprint")).compareTo("true") == 0 || request.getParameter("foppcl") != null && request.getParameter("foppcl").compareTo("true") == 0 || request.getAttribute("foppcl") != null && ((String)request.getAttribute("foppcl")).compareTo("true") == 0 || request.getParameter("fopps") != null && request.getParameter("fopps").compareTo("true") == 0 || request.getAttribute("fopps") != null && ((String)request.getAttribute("fopps")).compareTo("true") == 0 || request.getParameter("foprtf") != null && request.getParameter("foprtf").compareTo("true") == 0 || request.getAttribute("foprtf") != null && ((String)request.getAttribute("foprtf")).compareTo("true") == 0 || request.getParameter("fopmif") != null && request.getParameter("fopmif").compareTo("true") == 0 || request.getAttribute("fopmif") != null && ((String)request.getAttribute("fopmif")).compareTo("true") == 0 || request.getParameter("foptxt") != null && request.getParameter("foptxt").compareTo("true") == 0 || request.getAttribute("foptxt") != null && ((String)request.getAttribute("foptxt")).compareTo("true") == 0) {
            this.logger.error((Object)"For FOP transformation use the StrutsCXFOPTransformer or an equivalent instead.");
        } else {
            this.logger.debug((Object)"transform()");
            Document document = null;
            if (doc instanceof Document) {
                document = (Document)doc;
                this.logger.debug((Object)"deal with an JDOM Document!");
            } else {
                this.logger.error((Object)"did not get an JDOM Document!!");
            }
            this.takeAction(request, response, session, servlet, document, encoding, debug);
        }
        this.logger.debug((Object)"------------------------------------------- DOCUMENT SUCCESSFULLY SENT TO CLIENT");
    }

    protected void makeTransformation(String xslFile, HttpServletRequest request, HttpServletResponse response, HttpSession session, ServletConfig servlet, Document document, String encoding) throws StrutsCXXSLTException {
        try {
            long timer = 0L;
            JDOMSource sourceFile = new JDOMSource(document);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            StrutsCXURIResolver uriResolver = new StrutsCXURIResolver("http://" + request.getServerName() + ":" + new Integer(request.getServerPort()).toString() + request.getContextPath(), servlet);
            tFactory.setURIResolver(uriResolver);
            Templates xslTemplate = this.createXSLTemplate(servlet, xslFile, tFactory);
            Transformer transformer = xslTemplate.newTransformer();
            timer = System.currentTimeMillis();
            transformer.setOutputProperty("encoding", encoding);
            transformer.transform((Source)sourceFile, new StreamResult((OutputStream)response.getOutputStream()));
            this.logger.debug((Object)("XSL Transforming time is: " + (System.currentTimeMillis() - timer) + "ms"));
        }
        catch (TransformerConfigurationException tce) {
            this.logger.error((Object)"TransformerConfigurationException", (Throwable)tce);
            throw new StrutsCXXSLTException("TransformerConfigurationException\n" + tce.toString());
        }
        catch (TransformerException te) {
            this.logger.error((Object)"TransformerException", (Throwable)te);
            throw new StrutsCXXSLTException("TransformerException\n" + te.toString());
        }
        catch (IOException ioe) {
            this.logger.error((Object)"IOException", (Throwable)ioe);
            throw new StrutsCXXSLTException("IOException\n" + ioe.toString());
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception", (Throwable)e);
            e.printStackTrace();
        }
    }

    protected Templates createXSLTemplate(ServletConfig servlet, String xslFile, TransformerFactory tFactory) throws StrutsCXXSLTException {
        Templates xslTemplate = null;
        try {
            URL url = servlet.getServletContext().getResource(xslFile);
            if (url == null) {
                throw new StrutsCXXSLTException("Stylesheet not found: " + xslFile);
            }
            URLConnection urlConn = servlet.getServletContext().getResource(xslFile).openConnection();
            urlConn.connect();
            Date lastModified = new Date(urlConn.getLastModified());
            Date timeStamp = (Date)servlet.getServletContext().getAttribute("com.cappuccinonet.strutscx" + xslFile + ".time");
            this.logger.debug((Object)("file last modified: " + lastModified.toString()));
            this.logger.debug((Object)("the time we know: " + timeStamp));
            if (timeStamp == null || servlet.getServletContext().getAttribute("com.cappuccinonet.strutscx" + xslFile) == null || timeStamp.compareTo(lastModified) != 0) {
                this.logger.debug((Object)"XSL File has changed: reparsing...!");
                StreamSource ss = new StreamSource(urlConn.getInputStream());
                xslTemplate = tFactory.newTemplates(ss);
                servlet.getServletContext().setAttribute("com.cappuccinonet.strutscx" + xslFile, (Object)xslTemplate);
                servlet.getServletContext().setAttribute("com.cappuccinonet.strutscx" + xslFile + ".time", (Object)lastModified);
            } else {
                this.logger.debug((Object)"RECYCLE existing XSL File!");
                xslTemplate = (Templates)servlet.getServletContext().getAttribute("com.cappuccinonet.strutscx" + xslFile);
            }
        }
        catch (MalformedURLException mue) {
            this.logger.error((Object)"MalformedURLException");
            throw new StrutsCXXSLTException("MalformedURLException\n" + mue.toString());
        }
        catch (IOException ioe) {
            this.logger.error((Object)"IOException");
            throw new StrutsCXXSLTException("IOException\n" + ioe.toString());
        }
        catch (TransformerConfigurationException tce) {
            this.logger.error((Object)"TransformerConfigurationException");
            throw new StrutsCXXSLTException("TransformerConfigurationException\n" + tce.toString());
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception");
            e.printStackTrace();
        }
        return xslTemplate;
    }

    protected void makeNoTransformation(HttpServletResponse response, Document document, String encoding) throws StrutsCXXSLTException {
        try {
            XMLOutputter outputter = new XMLOutputter("  ", true);
            outputter.setEncoding(encoding);
            response.setContentType("text/xml; charset=" + encoding);
            PrintWriter out = response.getWriter();
            out.println(outputter.outputString(document));
            this.logger.debug((Object)"Sent the XML file directly to the client");
        }
        catch (IOException ioe) {
            this.logger.error((Object)"IOException while outputting");
            ioe.printStackTrace();
            throw new StrutsCXXSLTException("IOException while outputting\n" + ioe.toString());
        }
    }

    protected Document makeDocumentTransformation(String xslFile, HttpServletRequest request, HttpServletResponse response, HttpSession session, ServletConfig servlet, Document document, String encoding) throws StrutsCXXSLTException {
        this.logger.debug((Object)"makeDocumentTransformation()");
        Document resultDoc = null;
        try {
            long timer = 0L;
            this.logger.debug((Object)("makeDocumentTransformation() use following XSL Stylesheet " + xslFile));
            TransformerFactory tFactory = TransformerFactory.newInstance();
            StrutsCXURIResolver uriResolver = new StrutsCXURIResolver("http://" + request.getServerName() + ":" + new Integer(request.getServerPort()).toString() + request.getContextPath(), servlet);
            tFactory.setURIResolver(uriResolver);
            Templates xslTemplate = this.createXSLTemplate(servlet, xslFile, tFactory);
            Transformer transformer = xslTemplate.newTransformer();
            timer = System.currentTimeMillis();
            transformer.setOutputProperty("encoding", encoding);
            JDOMResult out = new JDOMResult();
            transformer.transform((Source)new JDOMSource(document), (Result)out);
            resultDoc = out.getDocument();
            this.logger.debug((Object)"makeDocumentTransformation() done");
            XMLOutputter outputter = new XMLOutputter("  ", true);
            outputter.setEncoding(encoding);
            this.logger.debug((Object)outputter.outputString(resultDoc));
            this.logger.debug((Object)("XSL Transforming time is: " + (System.currentTimeMillis() - timer) + "ms"));
        }
        catch (TransformerConfigurationException tce) {
            this.logger.error((Object)"TransformerConfigurationException");
            throw new StrutsCXXSLTException("TransformerConfigurationException\n" + tce.toString());
        }
        catch (TransformerException te) {
            this.logger.error((Object)"TransformerException");
            throw new StrutsCXXSLTException("TransformerException\n" + te.toString());
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception");
            e.printStackTrace();
        }
        return resultDoc;
    }

    protected Document getPipedDocument() {
        return this.pipedDocument;
    }

    protected void setPipedDocument(Document pipedDocument) {
        this.pipedDocument = pipedDocument;
    }

    protected void takeAction(HttpServletRequest request, HttpServletResponse response, HttpSession session, ServletConfig config, Document document, String encoding, boolean notransform) {
        this.logger.debug((Object)"takeAction()");
        if (notransform) {
            this.logger.debug((Object)"Going to send XML directly");
            try {
                this.makeNoTransformation(response, document, encoding);
            }
            catch (StrutsCXXSLTException e) {
                this.logger.error((Object)"StrutsCXXSLTException during XSLT transformation");
            }
        } else {
            this.logger.debug((Object)"Going to transforme XSL");
            List xslFiles = null;
            try {
                xslFiles = new StrutsCXXSLTUtil().getStylesheets(request, config);
            }
            catch (StrutsCXXSLTException e) {
                this.logger.error((Object)"Could not check if we will do single or multiple transformation");
            }
            if (xslFiles.size() == 1) {
                this.logger.debug((Object)"SINGLE TRANSFORMATION");
                String xslFile = (String)xslFiles.get(0);
                try {
                    this.makeTransformation(xslFile, request, response, session, config, document, encoding);
                }
                catch (StrutsCXXSLTException e) {
                    this.logger.error((Object)"StrutsCXXSLTException during XSLT transformation");
                }
            } else {
                this.logger.debug((Object)"MULTIPLE TRANSFORMATION");
                this.setPipedDocument(document);
                this.logger.debug((Object)"setMultiDocument(doc)");
                int i = 0;
                while (i < xslFiles.size() - 1) {
                    String xslFile = (String)xslFiles.get(i);
                    this.logger.debug((Object)("transform No.: " + i + " " + xslFile));
                    try {
                        this.setPipedDocument(this.makeDocumentTransformation(xslFile, request, response, session, config, this.getPipedDocument(), encoding));
                    }
                    catch (StrutsCXXSLTException e) {
                        this.logger.error((Object)"StrutsCXXSLTException during XSLT transformation");
                    }
                    ++i;
                }
                String lastXslFile = (String)xslFiles.get(xslFiles.size() - 1);
                this.logger.debug((Object)("transform (last): " + lastXslFile));
                try {
                    this.makeTransformation(lastXslFile, request, response, session, config, this.getPipedDocument(), encoding);
                }
                catch (StrutsCXXSLTException e) {
                    this.logger.error((Object)"StrutsCXXSLTException during XSLT transformation");
                }
                this.logger.debug((Object)"multiple transformation done");
            }
            this.logger.debug((Object)"transformation done");
        }
    }

    protected String extractEncoding(HttpServletRequest request) {
        String encoding = (String)request.getAttribute("encoding_key");
        this.logger.debug((Object)("encoding: " + encoding));
        if (encoding == null || encoding.equals("")) {
            this.logger.error((Object)"No encoding provide. Please provide the appropriat encoding!");
        }
        return encoding;
    }
}

