/*
 * Decompiled with CFR 0.152.
 */
package com.cappuccinonet.strutscx.xslt;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.ServletConfig;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StrutsCXURIResolver
implements URIResolver {
    protected Log logger = LogFactory.getLog(this.getClass());
    public String documentRoot;
    public ServletConfig config;

    public StrutsCXURIResolver(String documentRoot, ServletConfig servlet) {
        this.documentRoot = documentRoot;
        this.config = servlet;
    }

    public Source resolve(String href, String base) throws TransformerException {
        this.logger.debug((Object)("base is: " + base));
        this.logger.debug((Object)("href is: " + href));
        this.logger.debug((Object)("URL is: " + this.documentRoot + href));
        try {
            URL url = null;
            url = !href.startsWith("/") ? this.config.getServletContext().getResource("/" + href) : this.config.getServletContext().getResource(href);
            if (url == null) {
                throw new TransformerException("Could not resolve resource " + href);
            }
            URLConnection urlConn = url.openConnection();
            urlConn.connect();
            return new StreamSource(urlConn.getInputStream());
        }
        catch (MalformedURLException e) {
            this.logger.error((Object)("MalformedURLException with href string " + href + ": " + e));
            throw new TransformerException(e);
        }
        catch (IOException e) {
            this.logger.error((Object)("Could not connect to " + href + ": " + e));
            throw new TransformerException(e);
        }
    }
}

