/*
 * Decompiled with CFR 0.152.
 */
package com.cappuccinonet.strutscx.xslt;

import com.cappuccinonet.strutscx.exceptions.StrutsCXXSLTException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;

public class StrutsCXXSLTUtil {
    protected Log logger = LogFactory.getLog(this.getClass());

    public List getStylesheets(HttpServletRequest request, ServletConfig servlet) throws StrutsCXXSLTException {
        String xslKey = (String)request.getAttribute("xsl_key");
        ArrayList<String> xslFiles = new ArrayList<String>();
        if (!xslKey.endsWith("xsl")) {
            Document properties = (Document)servlet.getServletContext().getAttribute("com.cappuccinonet.strutscx.properties");
            if (properties == null) {
                throw new StrutsCXXSLTException("error in strutscx-config.xml, com.cappuccinonet.strutscx.properties not found in servlet context");
            }
            JXPathContext props = JXPathContext.newContext((Object)properties);
            String xpath = "/properties/strutscx-definitions/definition[@name='" + xslKey + "']/*";
            this.logger.debug((Object)("xpath statement: " + xpath));
            Iterator iter = props.iterate(xpath);
            while (iter.hasNext()) {
                String s = (String)iter.next();
                xslFiles.add(s);
                this.logger.debug((Object)("strutscx-definition value: " + s));
            }
            if (xslFiles.size() == 1) {
                this.logger.debug((Object)"strutscx-definition single");
            } else {
                this.logger.debug((Object)"strutscx-definition multiple");
            }
        } else {
            xslFiles.add(xslKey);
            this.logger.debug((Object)("xslFile to use: " + xslKey));
        }
        return xslFiles;
    }

    public String getStylesheet(HttpServletRequest request, ServletConfig servlet) throws StrutsCXXSLTException {
        List xslFiles = this.getStylesheets(request, servlet);
        return (String)xslFiles.get(0);
    }
}

