/*
 * Decompiled with CFR 0.152.
 */
package com.cappuccinonet.strutscx.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.servlet.ServletException;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;

public class StrutsCXLog4jInitPlugIn
implements PlugIn {
    private String encoding = "ISO-8859-1";
    private String config;
    private ActionServlet servlet;

    public void init(ActionServlet servlet, ModuleConfig config) throws ServletException {
        this.servlet = servlet;
        String configPath = this.getConfig();
        if (configPath != null) {
            if (configPath.startsWith("/")) {
                String string = configPath = configPath.length() > 1 ? configPath.substring(1) : "";
            }
            if (configPath.length() >= 1) {
                boolean isXMLConfigFile = configPath.endsWith(".xml");
                String contextPath = servlet.getServletContext().getRealPath("/");
                if (contextPath != null) {
                    String systemConfigPath = configPath.replace('/', File.separatorChar);
                    File log4jFile = new File(String.valueOf(contextPath) + systemConfigPath);
                    if (log4jFile.canRead()) {
                        log4jFile = null;
                        LogLog.warn((String)("Configuring Log4j from File: " + contextPath + systemConfigPath));
                        if (isXMLConfigFile) {
                            DOMConfigurator.configure((String)(String.valueOf(contextPath) + systemConfigPath));
                        } else {
                            PropertyConfigurator.configure((String)(String.valueOf(contextPath) + systemConfigPath));
                        }
                    }
                } else {
                    URL log4jURL = null;
                    try {
                        log4jURL = servlet.getServletContext().getResource("/" + configPath);
                    }
                    catch (MalformedURLException e) {
                        LogLog.error((String)"MalformedURLException");
                    }
                    if (log4jURL != null) {
                        LogLog.warn((String)("Configuring Log4j from URL at path: / " + configPath));
                        if (isXMLConfigFile) {
                            try {
                                DOMConfigurator.configure((URL)log4jURL);
                            }
                            catch (Exception e) {
                                LogLog.error((String)e.getMessage());
                            }
                        } else {
                            Properties log4jProps = new Properties();
                            try {
                                log4jProps.load(log4jURL.openStream());
                                PropertyConfigurator.configure((Properties)log4jProps);
                            }
                            catch (Exception e) {
                                LogLog.error((String)e.getMessage());
                            }
                        }
                    } else {
                        this.displayConfigNotFoundMessage();
                    }
                }
            } else {
                LogLog.error((String)"Zero length Log4j config file path given.");
                this.displayConfigNotFoundMessage();
            }
        } else {
            LogLog.error((String)"Missing log4j-config init parameter missing.");
            this.displayConfigNotFoundMessage();
        }
        LogLog.warn((String)"StrutsCX Log4j successfully configured!!");
    }

    private void displayConfigNotFoundMessage() {
        LogLog.warn((String)"No Log4j configuration file found at given path. Falling back.");
    }

    public void destroy() {
        LogLog.debug((String)"Cleaning up Log4j resources for context...");
        LogLog.debug((String)"Shutting down all loggers and appenders...");
        LogManager.shutdown();
        LogLog.debug((String)"Log4j cleaned up!!!");
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String string) {
        this.config = string;
    }
}

