/*
 * Decompiled with CFR 0.152.
 */
package com.cappuccinonet.strutscx.util;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class StrutsCXXMLReader {
    protected Log logger = LogFactory.getLog(this.getClass());
    private String xmlFile;
    private String encoding;
    private ServletConfig config;
    private Document document;
    private Element element;

    public StrutsCXXMLReader(ServletConfig config, String xmlFile) {
        this.xmlFile = xmlFile;
        this.config = config;
        this.encoding = "UTF-8";
        Document doc = null;
        try {
            doc = this.getDocumentFromXML(config, xmlFile, this.encoding);
        }
        catch (ServletException se) {
            this.logger.error((Object)"ServletException during loading an XML file");
            se.printStackTrace();
        }
        this.setDocument(doc);
    }

    public StrutsCXXMLReader(ServletConfig config, String xmlFile, String encoding) {
        this.xmlFile = xmlFile;
        this.config = config;
        this.encoding = encoding;
        if (this.encoding == null || this.encoding.compareTo("") == 0) {
            this.encoding = "UTF-8";
        }
        Document doc = null;
        try {
            doc = this.getDocumentFromXML(config, xmlFile, this.encoding);
        }
        catch (ServletException se) {
            this.logger.error((Object)"ServletException during loading an XML file");
            se.printStackTrace();
        }
        this.setDocument(doc);
    }

    private Document getDocumentFromXML(ServletConfig config, String xmlFile, String encoding) throws ServletException {
        Document document = new Document();
        this.logger.debug((Object)("begin to load: " + xmlFile));
        try {
            URLConnection urlConn = config.getServletContext().getResource(xmlFile).openConnection();
            urlConn.connect();
            Date lastModified = new Date(urlConn.getLastModified());
            Date timeStamp = (Date)config.getServletContext().getAttribute("com.cappuccinonet.strutscx" + xmlFile + ".time");
            this.logger.debug((Object)("file last modified: " + lastModified.toString()));
            this.logger.debug((Object)("the time we know: " + timeStamp));
            if (timeStamp == null || config.getServletContext().getAttribute("com.cappuccinonet.strutscx" + xmlFile) == null || timeStamp.compareTo(lastModified) != 0) {
                this.logger.debug((Object)"XML File has changed: reparsing...!");
                SAXBuilder builder = new SAXBuilder();
                InputStreamReader isr = new InputStreamReader(urlConn.getInputStream(), encoding);
                document = builder.build((Reader)isr);
                this.logger.debug((Object)"org.jdom.Document successfully created");
                List elements = document.getRootElement().getChildren();
                Iterator i = elements.iterator();
                while (i.hasNext()) {
                    Element current = (Element)i.next();
                    this.logger.debug((Object)(String.valueOf(current.getName()) + " " + current.getTextTrim()));
                }
                if (xmlFile.compareTo("/WEB-INF/strutscx-config.xml") == 0) {
                    config.getServletContext().setAttribute("com.cappuccinonet.strutscx.properties", (Object)document);
                    this.logger.debug((Object)(String.valueOf(xmlFile) + " set to ServletContext"));
                } else {
                    config.getServletContext().setAttribute("com.cappuccinonet.strutscx" + xmlFile, (Object)document);
                    config.getServletContext().setAttribute("com.cappuccinonet.strutscx" + xmlFile + ".time", (Object)lastModified);
                    this.logger.debug((Object)(String.valueOf(xmlFile) + " set to ServletContext"));
                }
            } else {
                this.logger.debug((Object)"RECYCLE existing XML File!");
                document = (Document)config.getServletContext().getAttribute("com.cappuccinonet.strutscx" + xmlFile);
            }
        }
        catch (JDOMException jde) {
            this.logger.error((Object)"JDOMException");
            jde.printStackTrace();
            throw new ServletException(jde.toString());
        }
        catch (MalformedURLException mue) {
            this.logger.error((Object)"MalformedURLException: Error in th URL pointing to the XML file!");
            mue.printStackTrace();
        }
        catch (IOException ioe) {
            this.logger.error((Object)"IOException");
            ioe.printStackTrace();
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception");
            e.printStackTrace();
            throw new ServletException(e.toString());
        }
        return document;
    }

    private void setDocument(Document document) {
        this.document = document;
    }

    public Document getDocument() {
        return this.document;
    }

    private void setElement(Element element) {
        this.element = element;
    }

    public Element getDocumentAsElement() {
        return this.element;
    }
}

