/*
 * Decompiled with CFR 0.152.
 */
package com.cappuccinonet.strutscx.xslt;

import com.cappuccinonet.strutscx.exceptions.StrutsCXXSLTException;
import com.cappuccinonet.strutscx.xslt.StrutsCXStandardTransformer;
import com.cappuccinonet.strutscx.xslt.StrutsCXURIResolver;
import com.cappuccinonet.strutscx.xslt.StrutsCXXSLTUtil;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import org.apache.avalon.framework.logger.Log4JLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.Options;
import org.apache.fop.configuration.Configuration;
import org.apache.log4j.Category;
import org.jdom.Document;
import org.jdom.transform.JDOMSource;

public class StrutsCXFOPTransformer
extends StrutsCXStandardTransformer {
    protected static org.apache.log4j.Logger logger_ = org.apache.log4j.Logger.getLogger((String)"StrutsCXFOPTransformer");

    public void transform(HttpServletRequest request, HttpServletResponse response, HttpSession session, ServletConfig servlet, Object doc, boolean notransform) throws StrutsCXXSLTException {
        this.logger.debug((Object)"------------------------------------------- TRANSFORM XML STARTED");
        Document document = (Document)doc;
        String encoding = this.extractEncoding(request);
        int fopparam = 0;
        if (notransform) {
            this.logger.debug((Object)"debug == true || xsl_clientside == true");
            super.takeAction(request, response, session, servlet, document, encoding, notransform);
        } else if (request.getParameter("fop") != null && request.getParameter("fop").compareTo("true") == 0 || request.getAttribute("fop") != null && ((String)request.getAttribute("fop")).compareTo("true") == 0) {
            fopparam = 1;
            this.takeAction(request, response, session, servlet, document, encoding, fopparam);
        } else if (request.getParameter("foppdf") != null && request.getParameter("foppdf").compareTo("true") == 0 || request.getAttribute("foppdf") != null && ((String)request.getAttribute("foppdf")).compareTo("true") == 0) {
            fopparam = 1;
            this.takeAction(request, response, session, servlet, document, encoding, fopparam);
        } else if (request.getParameter("fopsvg") != null && request.getParameter("fopsvg").compareTo("true") == 0 || request.getAttribute("fopsvg") != null && ((String)request.getAttribute("fopsvg")).compareTo("true") == 0 || request.getParameter("svg") != null && request.getParameter("svg").compareTo("true") == 0) {
            fopparam = 2;
            this.takeAction(request, response, session, servlet, document, encoding, fopparam);
        } else if (request.getParameter("fopawt") != null && request.getParameter("fopawt").compareTo("true") == 0 || request.getAttribute("fopawt") != null && ((String)request.getAttribute("fopawt")).compareTo("true") == 0) {
            fopparam = 3;
            this.takeAction(request, response, session, servlet, document, encoding, fopparam);
        } else if (request.getParameter("fopprint") != null && request.getParameter("fopprint").compareTo("true") == 0 || request.getAttribute("fopprint") != null && ((String)request.getAttribute("fopprint")).compareTo("true") == 0) {
            fopparam = 4;
            this.takeAction(request, response, session, servlet, document, encoding, fopparam);
        } else if (request.getParameter("foppcl") != null && request.getParameter("foppcl").compareTo("true") == 0 || request.getAttribute("foppcl") != null && ((String)request.getAttribute("foppcl")).compareTo("true") == 0) {
            fopparam = 5;
            this.takeAction(request, response, session, servlet, document, encoding, fopparam);
        } else if (request.getParameter("fopps") != null && request.getParameter("fopps").compareTo("true") == 0 || request.getAttribute("fopps") != null && ((String)request.getAttribute("fopps")).compareTo("true") == 0) {
            fopparam = 6;
            this.takeAction(request, response, session, servlet, document, encoding, fopparam);
        } else if (request.getParameter("foprtf") != null && request.getParameter("foprtf").compareTo("true") == 0 || request.getAttribute("foprtf") != null && ((String)request.getAttribute("foprtf")).compareTo("true") == 0) {
            fopparam = 7;
            this.takeAction(request, response, session, servlet, document, encoding, fopparam);
        } else if (request.getParameter("fopmif") != null && request.getParameter("fopmif").compareTo("true") == 0 || request.getAttribute("fopmif") != null && ((String)request.getAttribute("fopmif")).compareTo("true") == 0) {
            fopparam = 8;
            this.takeAction(request, response, session, servlet, document, encoding, fopparam);
        } else if (request.getParameter("foptxt") != null && request.getParameter("foptxt").compareTo("true") == 0 || request.getAttribute("foptxt") != null && ((String)request.getAttribute("foptxt")).compareTo("true") == 0) {
            fopparam = 9;
            this.takeAction(request, response, session, servlet, document, encoding, fopparam);
        } else if (request.getParameter("fopxml") != null && request.getParameter("fopxml").compareTo("true") == 0 || request.getAttribute("fopxml") != null && ((String)request.getAttribute("fopxml")).compareTo("true") == 0) {
            fopparam = 10;
            this.takeAction(request, response, session, servlet, document, encoding, fopparam);
        } else {
            this.logger.info((Object)"standard transform()");
            super.takeAction(request, response, session, servlet, document, encoding, notransform);
        }
        this.logger.debug((Object)"------------------------------------------- DOCUMENT SUCCESSFULLY SENT TO CLIENT");
    }

    protected void makeFOPTransformation(Document doc, String xslFile, HttpServletResponse response, HttpServletRequest request, HttpSession session, ServletConfig servlet, String encoding, int fopparam) throws StrutsCXXSLTException {
        try {
            long timer = 0L;
            JDOMSource sourceFile = new JDOMSource(doc);
            Driver driver = new Driver();
            driver.setLogger((Logger)new Log4JLogger((Category)logger_));
            driver.setOutputStream((OutputStream)response.getOutputStream());
            switch (fopparam) {
                case 1: {
                    driver.setRenderer(1);
                    response.reset();
                    response.setContentType("application/pdf");
                    break;
                }
                case 2: {
                    driver.setRenderer(9);
                    break;
                }
                case 3: {
                    driver.setRenderer(5);
                    break;
                }
                case 4: {
                    driver.setRenderer(2);
                    break;
                }
                case 5: {
                    driver.setRenderer(6);
                    break;
                }
                case 6: {
                    driver.setRenderer(7);
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    driver.setRenderer(3);
                    break;
                }
                case 9: {
                    driver.setRenderer(8);
                    break;
                }
                case 10: {
                    driver.setRenderer(4);
                }
            }
            this.logger.debug((Object)("fop with " + fopparam));
            Options options = (Options)servlet.getServletContext().getAttribute("fop_userconfig");
            String baseDir = (String)request.getAttribute("fop_basedir");
            if (baseDir == null || baseDir.compareTo("") == 0) {
                baseDir = (String)servlet.getServletContext().getAttribute("fop_basedir");
            }
            this.logger.debug((Object)("the FOP basedir is: " + baseDir));
            if (baseDir != null && baseDir.length() > 0) {
                Configuration.put((String)"baseDir", (Object)baseDir);
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            StrutsCXURIResolver uriResolver = new StrutsCXURIResolver("http://" + request.getServerName() + ":" + new Integer(request.getServerPort()).toString() + request.getContextPath(), servlet);
            tFactory.setURIResolver(uriResolver);
            Templates xslTemplate = this.createXSLTemplate(servlet, xslFile, tFactory);
            Transformer transformer = xslTemplate.newTransformer();
            transformer.setOutputProperty("encoding", encoding);
            timer = System.currentTimeMillis();
            transformer.transform((Source)sourceFile, new SAXResult(driver.getContentHandler()));
            this.logger.debug((Object)("XSL Transforming time is: " + (System.currentTimeMillis() - timer) + "ms"));
        }
        catch (TransformerConfigurationException tce) {
            this.logger.error((Object)"TransformerConfigurationException during FOP transformation", (Throwable)tce);
            throw new StrutsCXXSLTException("TransformerConfigurationException during FOP transformation\n" + tce.toString());
        }
        catch (TransformerException te) {
            this.logger.error((Object)"TransformerException during FOP transformation", (Throwable)te);
            throw new StrutsCXXSLTException("TransformerException during FOP transformation\n" + te.toString());
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception", (Throwable)e);
            e.printStackTrace();
        }
    }

    protected void takeAction(HttpServletRequest request, HttpServletResponse response, HttpSession session, ServletConfig servlet, Document document, String encoding, int fopparam) {
        String xslFile = "";
        try {
            xslFile = new StrutsCXXSLTUtil().getStylesheet(request, servlet);
        }
        catch (StrutsCXXSLTException e) {
            this.logger.error((Object)"StrutsCXXSLTException during reading the XSL Stylesheet String");
        }
        try {
            this.makeFOPTransformation(document, xslFile, response, request, session, servlet, encoding, fopparam);
        }
        catch (StrutsCXXSLTException e) {
            this.logger.error((Object)"StrutsCXXSLTException during XSLT transformation");
        }
    }
}

