/*
 * Decompiled with CFR 0.152.
 */
package com.cappuccinonet.strutscx.xslt;

import com.cappuccinonet.strutscx.exceptions.StrutsCXException;
import com.cappuccinonet.strutscx.exceptions.StrutsCXXSLTException;
import com.cappuccinonet.strutscx.xslt.StrutsCXDocumentBuilder;
import com.cappuccinonet.strutscx.xslt.StrutsCXDocumentBuilderFactoryImpl;
import com.cappuccinonet.strutscx.xslt.StrutsCXTransformer;
import com.cappuccinonet.strutscx.xslt.StrutsCXTransformerFactoryImpl;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;

public class StrutsCXServlet
extends HttpServlet {
    private ServletConfig servlet;
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    public Document strutscx_properties;
    JXPathContext props;

    public void init(ServletConfig servlet) throws ServletException {
        this.servlet = servlet;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        HttpSession session = request.getSession(false);
        this.strutscx_properties = (Document)this.servlet.getServletContext().getAttribute("com.cappuccinonet.strutscx.properties");
        this.props = JXPathContext.newContext((Object)this.strutscx_properties);
        this.logger.debug((Object)"------------------------------ STRUTSCXSERVLET STARTED");
        Object document = this.getXMLOutputDocument(request, session);
        String _debug = request.getParameter("debugxml");
        if (_debug == null || _debug.trim().compareTo("") == 0) {
            _debug = (String)request.getAttribute("debugxml");
        }
        boolean debug = new Boolean(_debug);
        String _clientside = request.getParameter("xsl_clientside");
        if (_clientside == null || _clientside.trim().compareTo("") == 0) {
            _clientside = (String)request.getAttribute("xsl_clientside");
        }
        boolean clientside = new Boolean(_clientside);
        if (debug & ((String)this.servlet.getServletContext().getAttribute("enable_debugxml")).compareTo("FALSE") == 0) {
            response.setContentType("text/html");
            PrintWriter out = null;
            try {
                out = response.getWriter();
            }
            catch (IOException e) {
                this.logger.error((Object)"could not write out message to the client");
            }
            out.println("<HTML>");
            out.println("<HEAD><TITLE>StrutsCXServlet - Warning</TITLE></HEAD>");
            out.println("<BODY>");
            out.println("Dear StrutsCX user: the use of debugxml as request parameter is not possible!<br/>");
            out.println("Check the strutscx-config.xml for details...");
            out.println("</BODY>");
            out.println("</BODY></HTML>");
        } else if (debug || clientside) {
            this.invoceStrutsCXTransformer(request, response, session, document, true);
        } else {
            this.invoceStrutsCXTransformer(request, response, session, document, false);
        }
        this.logger.debug((Object)"------------------------------ STRUTSCXSERVLET'S JOB DONE");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.doPost(request, response);
    }

    public void destroy() {
    }

    private StrutsCXTransformer getStrutsCXTransformer(String name) throws StrutsCXException {
        StrutsCXTransformerFactoryImpl stf = new StrutsCXTransformerFactoryImpl();
        StrutsCXTransformer strutsCXTransformer = stf.createStrutsCXTransformer(name);
        return strutsCXTransformer;
    }

    private StrutsCXDocumentBuilder getStrutsCXDocumentBuilder(String name) throws StrutsCXException {
        this.logger.debug((Object)"getStrutsCXDocumentBuilder(String name)");
        StrutsCXDocumentBuilderFactoryImpl stf = new StrutsCXDocumentBuilderFactoryImpl();
        StrutsCXDocumentBuilder strutsCXDocumentBuilder = stf.createStrutsCXDocumentBuilder(name);
        return strutsCXDocumentBuilder;
    }

    private Object getXMLOutputDocument(HttpServletRequest request, HttpSession session) {
        this.logger.debug((Object)"getXMLOutputDocument(HttpServletRequest request, HttpSession session)");
        String documentbuilder_id = (String)request.getAttribute("com.cappuccinonet.strutscx.strutscxdocumentbuilder_id");
        if (documentbuilder_id == null) {
            documentbuilder_id = "standard";
        }
        StrutsCXDocumentBuilder documentBuilder = null;
        try {
            documentBuilder = this.getStrutsCXDocumentBuilder((String)this.props.getValue("/properties/documentbuilder/class[@id = '" + documentbuilder_id + "']"));
        }
        catch (StrutsCXException e) {
            this.logger.error((Object)"Error during create of XML-Output-Document.");
            e.printStackTrace();
        }
        Document doc = null;
        try {
            doc = (Document)documentBuilder.createDocument(request, session, this.servlet);
        }
        catch (StrutsCXXSLTException e) {
            this.logger.error((Object)"StrutsCXXSLTException while building the XML-Output-Document");
            e.printStackTrace();
        }
        return doc;
    }

    private void invoceStrutsCXTransformer(HttpServletRequest request, HttpServletResponse response, HttpSession session, Object document, boolean notransform) {
        this.logger.debug((Object)"invoceStrutsCXTransformer()");
        String transformer_id = (String)request.getAttribute("com.cappuccinonet.strutscx.strutscxtransformer_id");
        this.logger.debug((Object)("the request contains this transformer_id: " + transformer_id));
        if (notransform) {
            transformer_id = "standard";
            request.setAttribute("debugxml", (Object)"TRUE");
            this.logger.debug((Object)"DEBUGXML IS SET!");
        } else if (transformer_id == null) {
            this.logger.debug((Object)"transformer_id = null");
            if (((String)this.servlet.getServletContext().getAttribute("enable_fop")).compareTo("TRUE") == 0) {
                this.logger.debug((Object)"ENABLE_FOP = true");
                this.logger.debug((Object)("FOP_PARAM " + request.getParameter("fop")));
                if (request.getParameter("fop") != null && request.getParameter("fop").compareTo("true") == 0 || request.getAttribute("fop") != null && ((String)request.getAttribute("fop")).compareTo("true") == 0 || request.getParameter("foppdf") != null && request.getParameter("foppdf").compareTo("true") == 0 || request.getAttribute("foppdf") != null && ((String)request.getAttribute("foppdf")).compareTo("true") == 0 || request.getParameter("fopsvg") != null && request.getParameter("fopsvg").compareTo("true") == 0 || request.getAttribute("fopsvg") != null && ((String)request.getAttribute("fopsvg")).compareTo("true") == 0 || request.getParameter("fopawt") != null && request.getParameter("fopawt").compareTo("true") == 0 || request.getAttribute("fopawt") != null && ((String)request.getAttribute("fopawt")).compareTo("true") == 0 || request.getParameter("fopprint") != null && request.getParameter("fopprint").compareTo("true") == 0 || request.getAttribute("fopprint") != null && ((String)request.getAttribute("fopprint")).compareTo("true") == 0 || request.getParameter("foppcl") != null && request.getParameter("foppcl").compareTo("true") == 0 || request.getAttribute("foppcl") != null && ((String)request.getAttribute("foppcl")).compareTo("true") == 0 || request.getParameter("fopps") != null && request.getParameter("fopps").compareTo("true") == 0 || request.getAttribute("fopps") != null && ((String)request.getAttribute("fopps")).compareTo("true") == 0 || request.getParameter("foprtf") != null && request.getParameter("foprtf").compareTo("true") == 0 || request.getAttribute("foprtf") != null && ((String)request.getAttribute("foprtf")).compareTo("true") == 0 || request.getParameter("fopmif") != null && request.getParameter("fopmif").compareTo("true") == 0 || request.getAttribute("fopmif") != null && ((String)request.getAttribute("fopmif")).compareTo("true") == 0 || request.getParameter("foptxt") != null && request.getParameter("foptxt").compareTo("true") == 0 || request.getAttribute("foptxt") != null && ((String)request.getAttribute("foptxt")).compareTo("true") == 0) {
                    transformer_id = "fop";
                    this.logger.debug((Object)"FOP");
                } else {
                    this.logger.debug((Object)"use standard");
                    transformer_id = "standard";
                }
            } else {
                transformer_id = "standard";
            }
        }
        this.logger.debug((Object)("transformer_id set to " + transformer_id));
        String transformer_class = (String)this.props.getValue("/properties/transformer/class[@id = '" + transformer_id + "']");
        this.logger.debug((Object)("transformer_class set to " + transformer_class));
        try {
            StrutsCXTransformer strutsCXTransformer = this.getStrutsCXTransformer(transformer_class);
            strutsCXTransformer.transform(request, response, session, this.servlet, document, notransform);
        }
        catch (StrutsCXException e) {
            this.logger.error((Object)("StrutsCXEception during instantiating " + transformer_class));
            e.printStackTrace();
        }
        catch (StrutsCXXSLTException e1) {
            this.logger.error((Object)("StrutsCXXSLTException during using " + transformer_class));
            e1.printStackTrace();
        }
    }
}

