/*
 * Cr le  8 juin 2004
 *
 * Codes Open Source pour Le Cahier du Programmeur Java[3] : 
 *		Java & XML: Le mariage de deux technologies complmentaires et autonomes
 * 
 * Auteur : R.Fleury (renaud.fleury@free.fr)
 */
package com.automne.octopuss.test.strutscx.a19s.action;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

import com.cappuccinonet.strutscx.util.StrutsCXConstants;

/**
 * Projet  : TP_StrutsCX
 * Classe  : A19SAction
 * Version : 1.0
 * But     : Action simple de Struts permettant de transformer ct serveur un flux xml avec une xsl vers un  
 * 
 */
public class A19SAction extends Action {
	
	protected Log logger = LogFactory.getLog(this.getClass());
	private static final String MIRROR_URL="http://www.application-servers.com/rss/appservers.rss"; 

	/**
	 * Constructeur par dfaut
	 */
	public A19SAction() {
		super();
	}
	/**
	 * Mthode unique  surcharger pour excution d'oprations lors de l'invocation de l'Action. Ici, il s'agit de 
	 * transformer un flux xml provenant d'un site distant : http://www.application-servers.com en page Web HTML.
	 */
	public ActionForward execute(
			ActionMapping mapping,
			ActionForm form,
			javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
			throws java.io.IOException, javax.servlet.ServletException {

			logger.debug("----------------------------- A19SAction -----------------------------");

			// dfinition de la  utiliser: a19s
			String xslFile = "a19s";
			logger.debug("Using strutscx-definition: " + xslFile);
			// Affectation  la requte le nom de  XSL  utiliser soit 
			request.setAttribute(StrutsCXConstants.XSL_KEY, xslFile);
			//On loggue la dfinition StrutsCX utilise 
			logger.debug("Put XSL string: " + xslFile+" in request");
			// Rcupration du flux XML pour parsing via le builder Xerces SAX
			SAXBuilder streamXml =new SAXBuilder(false);
			//Initialisation 
			Document doc=null;
			try {
				//Lancement du parsing du flux XML rcupr.
				doc = streamXml.build(new URL(MIRROR_URL).openStream());
			} catch (MalformedURLException e) {
				//Une exception due  une mauvaise url!  
				e.printStackTrace();
			} catch (JDOMException e) {
				//Une exception due lors du parsing!
				e.printStackTrace();
			} catch (IOException e) {
				//Une exception de flux d'entre/sortie: Mauvais flux XML? :/
				e.printStackTrace();
			}
			//Le flux xml  transformer  stocker dans la requte portant le nom de la dfinition StrutsCX. 
			request.setAttribute("a19s", doc);
			//On loggue en mode debug uniquement le document XML rsultant du parsing 
			logger.debug("set XML document: " + doc.toString());
			// Ici on ordonne les diffrentes options pour la transformation
			request.setAttribute(StrutsCXConstants.ENCODING_KEY, "ISO-8859-1");
			request.setAttribute("transformer_framework","StrutsCX");
			request.setAttribute("transformer_version","v0.9.4");
			//On route vers la page dont on a demand la transformation XSL
			return (mapping.findForward("success"));

		}
	
}
