#!/usr/bin/python
# -*- coding: ISO-8859-15 -*-
"""\
Deux utilisations possibles:

    o si seule l'archive est fournie en argument,
    la liste des fichiers contenus est affichée

    o si un fichier est aussi fourni, il est inséré dans l'archive
    si l'archive ne possède pas déjà un fichier sous ce nom puis
    affiche la liste des fichiers

Utilisation: %(prog)s <nom de l'archive> [nom du fichier]
"""
import sys
import os
from zipfile import ZipFile, is_zipfile

FILENAME = 'Nom fichier'
MODIFIED = 'Modifié'
SIZE = 'Taille'
FILES = 'fichier(s)'
HEADER = '%-46s %19s %12s' % (FILENAME, MODIFIED, SIZE)

class ExtendedZipFile(ZipFile):
    def printdir(self):
        """Print a table of contents for the zip file."""
        print(HEADER)
        print(len(HEADER) * '-')
        for zinfo in self.filelist:
            date = '%d‑%02d‑%02d %02d:%02d:%02d' % zinfo.date_time
            filename = zinfo.filename
            if len(filename) > 40:
                filename = '...%s' % filename[-40:]
            print('%-46s %s %12d' % (filename, date, zinfo.file_size))
        print(len(HEADER) * '-')
        print('%d %s' % (len(self.filelist), FILES))

def add_to_zip(zip, path):
    """Ajoute un fichier dans une archive zip."""
    zip = ZipFile(zip, mode="a")
    try:
        if path not in zip.namelist():
            zip.write(path, path)
            return True
        return False
    finally:
        zip.close()

def print_zip(zip):
    """Affiche le contenu d'un fichier zip."""
    zip = ExtendedZipFile(zip)
    try:
        print 'Contenu de %s:\n' % zip.filename
        zip.printdir()
    finally:
        zip.close()

if __name__ == '__main__':
    if len(sys.argv) < 2:
        print(__doc__ % {'prog': sys.argv[0]})
        sys.exit(0)

    zip = sys.argv[1]
    if not is_zipfile(zip):
        print('"%s" n\'est pas un fichier zip' % zip)
        sys.exit(0)

    if len(sys.argv) > 2:
        if not add_to_zip(zip, sys.argv[2]):
            print('Fichier avec le même nom déjà existant')
        else:
            print('Fichier ajouté')
    else:
        print_zip(zip)

