#!/usr/bin/python
# -*- coding: utf8 -*-
import shelve
import atexit
from pickle import dumps

data = None
objects = []

def _load_objects():
    print('Loading...')
    global data
    data = shelve.open('objects.bin')

def _save_objects():
    print('Saving...')
    for ob in objects:
        data[ob._id] = ob.__dict__
    data.close()

class Persistent(object):

    def __new__(cls, id_):
        ob = super(Persistent, cls).__new__(cls)
        if id_ in data:
            ob.__dict__ = data[id_]
        objects.append(ob)
        return ob

    def __init__(self, id_):
        self._id = id_

# chargement des objets
_load_objects()

# _save_objects sera appelée à la fermeture du programme
atexit.register(_save_objects)

if __name__ == '__main__':
    import random

    class MyClass(Persistent):

        def some_code(self, value):
            self.value = value

    test = MyClass('the id')
    try:
        print('ancienne valeur %s' % test.value)
    except AttributeError:
        print('ancienne valeur : aucune')
    test.some_code(random.randint(1, 1000))
    print('nouvelle valeur %s' % test.value)

