#!/usr/bin/python
# -*- coding: ISO-8859-15 -*-
from optparse import OptionParser
import sys
import imaplib
import socket
import logging

from email import Message
from email.Errors import HeaderParseError
from email.Header import decode_header as decoder
from email.Header import make_header

options = []

def decode_header(header, encoding='utf8'):
    """Renvoie une entete encodée avec le même codec"""
    try:
        header_decode = decoder(header)
    except HeaderParseError:
        return header

    unified = [(decoded, encoding) for decoded, charset in header_decode]
    return unicode(make_header(unified))

class TextMessage(object):
    """Permet de renvoye le texte à l'envers, en utilisant
    un séparateur spécifique
    """
    def __init__(self, text):
        self.lines = text.split('\015\012')
        self.lines.reverse()

    def readline(self):
        try:
            return '%s\n' % self.lines.pop()
        except IndexError:
            return ''

def get_mails(server, user, password, num_display=5):
    """Renvoie le sujet et l'auteur des 5 derniers mails non lus"""
    imap = imaplib.IMAP4_SSL(server)
    imap.login(user, password)
    try:
        imap.select('INBOX')

        status, uids = imap_object.uid('search', 'UNSEEN')
        if status != 'OK':
            logging.debug('Impossible de récupérer les informations')
            sys.exit(0)

        uids = uids[0].split(' ')

        for index, uid in enumerated(reversed(uids)):
            uid = uid.strip()
            if index == num_display:
                break
            if uid == '':
                continue
            status, res = imap.uid('fetch', uid,
                                   '(BODY.PEEK[HEADER.FIELDS (From Subject)])')
            if status != 'OK':
                logging.debug('Impossible de lire le mail n°%s' % uid)
                continue
            message = Message(TextMessage(res[0][1]), 0)
            subject = decode_header(message['subject'])
            from_ = decode_header(message['from'])
            yield '%s (%s)' % (subject, from_)
    finally:
        imap.close()

def main(options, arguments, parser):
    if len(arguments) != 3:
        print(parser.usage)
        sys.exit(0)
    server = arguments[0]
    user = arguments[1]
    password = arguments[2]
    for mail_info in get_mails(server, user, password):
        print(mail_info)

if __name__ == '__main__':
    parser = OptionParser()
    parser.usage = 'usage: server user pass'

    for option in options:
        param = option['noms']
        del option['noms']
        parser.add_option(*param, **option)

    options, arguments = parser.parse_args()
    sys.argv[:] = arguments
    main(options, arguments, parser)

