#!/usr/bin/python
# -*- coding: utf8 -*-
import os.path
import sys

from compiler import parse
from compiler import walk
from compiler.visitor import ASTVisitor
from compiler.ast import Stmt, Class, Function

class DisplayVisitor(ASTVisitor):
    """Visite l'AST"""
    def __init__(self, name):
        self.name = name

    def _visit_node(self, node):
        """Appele sur les node"""
        if (isinstance(node, Stmt) or
            (hasattr(node, 'name') and node.name != self.name)):
            for subnode in node.getChildNodes():
                self._visit_node(subnode)
            return

        if not (isinstance(node, Class) or isinstance(node, Function)):
            return

        print('Trouvé ligne %d' % node.lineno)
        if node.doc is None:
            print('\n\tAucun docstring\n')
        else:
            print('\n\t%s\n' % node.doc)

    visitClass = _visit_node
    visitFunction = _visit_node
    visitStmt = _visit_node

def print_module(path, element, verbose=False):
    """Permet l'affichage d'un doctstring de classe ou de fonction"""
    with open(path) as f:
        ast = parse(f.read())

    walk(ast, DisplayVisitor(element))

if __name__ == '__main__':
    print_module(sys.argv[1], sys.argv[2])

