#!/usr/bin/python
# -*- coding: utf8 -*-
import re
import sys

FIND_LINK = r'(?P<link>https|ftp|http+://+[^ \t\n\r\f\v\<]*)'
FIND_MAIL = r'(?P<mail>[\w\‑][\w\‑\.]+@[\w\‑][\w\‑\.]+)'
FIND = re.compile(r'%s|%s' % (FIND_LINK, FIND_MAIL), re.I | re.M)
IS_LINK = re.compile(FIND_LINK, re.I)
REPLACE_LINK= r'<a href="%(link)s" target="_blank">%(link)s</a>'
REPLACE_MAIL = r'<a href="mailto:%(mail)s">%(mail)s</a>'

def _replace(match):
    value = match.group()
    if IS_LINK.search(value) is not None:
        res = REPLACE_LINK % match.groupdict()
    else:
        res = REPLACE_MAIL % match.groupdict()
    print('%s -> %s' % (value, res))
    return res

if __name__ == '__main__':
    filename = sys.argv[1]
    text = open(filename).read()

    with open('res_%s' % filename, 'w') as result:
        result.write(FIND.sub(_replace, text))

