#!/usr/bin/python
# -*- coding: utf8 -*-
import sys
import os
import re

usage = """\
Utilisation :

    %(prog)s <fichier> <expression> <substitut>

Par exemple:

    %(prog)s pim.txt pam poum

Remplacera toutes les occurences de "pam" en "poum"
"""

def sub_text(path, expr, repl):
    """ remplace un texte dans un fichier """
    # remplacement
    with open(path) as source:
        with open('%s.tmp' % path, 'w') as target:
            target.write(re.sub(expr, repl, source.read()))

    # renommage si tout s'est bien passé
    os.rename(path, '%s~' % path)
    os.rename('%s.tmp' % path, path)

if __name__ == '__main__':
    if len(sys.argv) != 4:
        print(usage % {'prog': sys.argv[0]})
        sys.exit(0)

    sub_text(*sys.argv[1:4])

