<?php
// --------- scr_11_12.php ou :
/*---------- src_img_050.php----------------------------*/
/*------------------------------------------------------*/
/**  Statistiques sur graphique  barres			*/
/*------------------------------------------------------*/
/*------------------------------------------------------*/
/** dfinir le cadre de l'image globale			*/
/*------------------------------------------------------*/
$x_larg_img	=	580;
$y_haut_img	=	350;
//
/** talon pour les noms des colonnes (tiquettes x)	*/
/** marge gauche pour les indications d'chelle		*/
$y_marge_horiz	=	30;
$x_marge_gauche	=	38;
/**										*/
/** rservation d'un espace mmoire pour l'image		*/
$img	=	imagecreate($x_larg_img, $y_haut_img);
/** dfinition des couleurs  employer				*/
	$blanc	= imagecolorallocate($img, 255, 255, 255);
	$clair	= imagecolorallocate($img, 200, 200, 200);
	$sombre	= imagecolorallocate($img, 100, 100, 100);
	$noir		= imagecolorallocate($img, 000, 000, 000);
/*------------------------------------------------------*/
/* donnes obtenues dans un tableau				*/
/*    alimenter  partir d'une base de donnes, par ex.*/
/* les cls deviendront les tiquettes de bas de tableau*/
/* les valeurs seront reprsentes par des barres vertic*/
/*------------------------------------------------------*/
$data = array
(
	"jan"=>70,
	"fev"=>190,
	"mar"=>180,
	"avr"=>102,
	"mai"=>90,
	"jun"=>80,
	"jui"=>30,
	"aou"=>25,
	"sep"=>65,
	"oct"=>110,
	"nov"=>64,
	"dec"=>22
); 
/*------------------------------------------------------*/
/** les cadres de l'image et du graphique  insrer	*/
/*------------------------------------------------------*/
/** obtention de la valeur maximale				*/
/** pour prparation de la hauteur du graphique.		*/
/** nombre d'lments en table					*/
/**										*/
$valeur_max	=	max($data);							
//
$nbr_elem	=	sizeof($data); 
/**										*/
/** espace par colonne, arrondi vers le bas			*/
$espace_col	= 
	floor(($x_larg_img - $x_marge_gauche) / $nbr_elem);
/**										*/
/** dimensions de la zone graphique				*/
/** = hauteur de l'image - pied et en-tte			*/
/** = largeur recalcule sur n espaces_colonnes,		*/
/**			pour obtenir une largeur avec aration	*/
/**										*/
$y_haut_gr	=	$y_haut_img - (2 * $y_marge_horiz);
$x_larg_gr	=	$nbr_elem	*	$espace_col;
/**										*/
/** dessin d'une image de fond en couleur claire		*/
/** dessin du cadre de la zone graphique			*/
/**										*/
	imagefilledrectangle($img, 
		0, 0,
		$x_larg_img, $y_haut_img-1, 
		$clair);
/**										*/
	imagerectangle($img, 
		$x_marge_gauche, $y_marge_horiz,
		$x_marge_gauche+$x_larg_gr, $y_marge_horiz+$y_haut_gr, 
		$noir);
/**										*/
/*------------------------------------------------------*/
/** le titre en en-tte						*/
/*------------------------------------------------------*/
/** choix d'une police standard : n3				*/
$police_t	=3;
$titre= "Visites du site en 2004";
/**										*/
/** calcul de la dimension = n pixels par caract.		*/
$txt_larg	= imagefontwidth($police_t) * strlen($titre);
/**										*/
/** centrage horizontal du titre					*/
$x_pos	= (int)
	($x_marge_gauche + ($x_larg_gr - $txt_larg)/2);
$y_pos	= 3; /* positionnement depuis le bord suprieur	*/
/**										*/
	imagestring($img, $police_t, 
	$x_pos, $y_pos, $titre, 
	$noir);
/**										*/
/*------------------------------------------------------*/
/** positionnement des tiquettes-repres en marge		*/
/** et des lignes horizontales de niveau			*/
/*------------------------------------------------------*/
/**										*/
$police_etiq	=2;	
$nbr_niv		=4;	/* nombre de lignes horizontales	*/
/**										*/
/** valeur d'une tranche entre deux niveaux			*/
/** prvoir un niveau vide au-dessus pour aration		*/
/**										*/
$tranche_val	=$valeur_max / $nbr_niv; 
$tranche_pix	=($y_haut_gr)/($nbr_niv+1); 
/**										*/
/** positionner les repres dans la marge gauche		*/
/**       
/** pour rappel les valeurs x=0 et y=0				*/
/**     sont dans le coin suprieur gauche			*/
/**	------------------------------				*/
/** 1. les repres	en marge gauche				*/
/** prvoir un repre zro et un repre au del de max	*/
/** le positionnement se fait de bas vers le haut		*/
/** le repre zro concide avec le bas du graphique	*/
/**										*/
for ($i = 0; $i <= $nbr_niv+1; $i++)
{
	/** calcul de la valeur du repre				*/
	$repere	= (int) ($tranche_val * $i);
	/**									*/
	/** calcul du positionnement vertical			*/
	/** prise en compte de la hauteur du repre		*/
	$y_pos	= $y_marge_horiz + $y_haut_gr  
			- (int)($tranche_pix*$i);
	$txt_haut	= imagefontheight($police_etiq);
	/**									*/
	/** calcul du positionnement horizontal			*/
	/** prise en compte de la largeur du repre		*/
	$txt_larg	= imagefontwidth($police_etiq) 
					* strlen($repere);
	$x_pos	= (int) (($x_marge_gauche - $txt_larg) / 2);
	$x_pos	= max(1, $x_pos);
	/**									*/
	/** insertion du repre						*/
	imagestring($img, $police_etiq, 
		$x_pos, $y_pos - (int) ($txt_haut/2),
		$repere, $blanc);
/**	------------------------------				*/
/** 2. les lignes horizontales					*/
/**     sauf pour les lignes de bas et de haut		*/
/**										*/
	if (!$i == 0)
	{
	imageline($img, 
		$x_marge_gauche - 3, $y_pos, 
		$x_marge_gauche + $x_larg_gr, $y_pos, 
		$blanc);
	}
}
/**-----------------------------------------------------*/
/** dessin des barres verticales					*/
/**-----------------------------------------------------*/
/** interstice entre les colonnes					*/
$interstice	=	3;
/**														*/
/** nombre de pixels par pourcentage				*/
/** cad, pour obtenir la hauteur de la colonne,		*/
/**  attribuer  chaque valeur le nombre de pixel n	*/
/**  Ce nombre est appel ici chelle d'unit		*/
/**										*/
$ech_unit= $y_haut_gr / (($nbr_niv+1) * $tranche_val);
/**										*/
/** transformation de chaque lment de table en col	*/
/**										*/
for ($i=0; list($x_cle, $y_valeur) = each($data); $i++)
	{
	/** ---------------------------------			*/
	/** valeurs de table devenant colonnes			*/
	/**									*/
	/** pour chaque valeur :					*/
	/** calcul du point de dpart : coin sup. gauche	*/
	/** position x_deb  : progression vers la droite	*/
	/** position y_deb  : proportionnelle  la valeur	*/
	/**													*/
	/** calcul du point d'arrive : coin inf. droit		*/
	/** position x_fin	: progression vers la droite	*/
	/** position y_fin	: systmatiquement au plancher */
	$x_deb = $x_marge_gauche + $i*$espace_col + $interstice;
	$x_max = $x_marge_gauche + ($i+1)*$espace_col - $interstice;
	/**									*/
	$y_fin = $y_marge_horiz + $y_haut_gr;
	$y_deb = $y_fin - (int) ($y_valeur * $ech_unit);
	/**									*/
	imagefilledrectangle($img,
				$x_deb, $y_deb, 
				$x_max, $y_fin, 
				$sombre);
	/** ---------------------------------			*/
	/** libells de pied correspondant aux cls		*/
	//												//
	/** posit. x : cadrer sur la colonne correspondante	*/
	/**				en centrant le texte		*/
	$txt_larg = imagefontwidth($police_etiq) 
				* strlen($x_cle);
	$x_pos_lib = $x_deb + 
				(int)(($espace_col - $txt_larg) / 2);
	$x_pos_lib = max ($x_deb, $x_pos_lib);
	/**									*/
	/** posit. y : systmatiquement sous le plancher	*/
	$y_pos_lib = $y_fin + 3;
	//												//
	imagestring($img, $police_etiq, 
				$x_pos_lib, $y_pos_lib, 
				$x_cle, $noir);
	}
/*------------------------------------------------------*/
// affichage de l'image								
//
header("Content-type: image/jpg");
imagejpeg($img);
imagedestroy($img);
?>