<?php
// scr_08_05.php
/***
 * Database connection methods; either persistent or non-persistent. The latter
 * (ECLIPSE_DB_NON_PERSISTENT) is the default.
 ***/
define('ECLIPSE_DB_PERSISTENT'    , true);
define('ECLIPSE_DB_NON_PERSISTENT', false);

 ***/
class Database
{
    // DATA MEMBERS

     /***
     * The name of the database
     * @type string
     ***/
    var $name;

    /***
     * The host the database is on; if left empty, sockets are used
     * @type string
     ***/
    var $host;

    /***
     * The internal link to the database
     * @type int
     ***/
    var $link;

    // CREATORS

    /***
     * Prepare a new database connection on the specified host
     * @param $name the name of the database
     * @param $host the host the database is running on
     ***/
    function Database($name, $host)
    {
        $this->name = $name;
        $this->host = $host;
        $this->link = 0;
    }

    // MANIPULATORS

    /***
     * Set the internal link identifier; this is a protected method.
     * @param $link the resource index
     * @returns void
     * @protected
     ***/
    function setLink($link)
    {
        $this->link = $link;
    }

    /***
     * Make a connection with a database; return true on success,
     * false otherwise
     * @param $username the name of the database user
     * @param $password the password of the database user
     * @param $type the connection type; either
     * ECLIPSE_DB_NON_PERSISTENT or
     * ECLIPSE_DB_PERSISTENT
     * @returns bool
     ***/
    function connect($username, $password, $type = ECLIPSE_DB_NON_PERSISTENT)
    {
        die('Method connect of class Database is not ' .
            'implemented.');
    }

    /***
     * Close the connection with the database; this method needn't be called
     * when using a persistent connection
     * @returns void
     ***/
    function disconnect()
    {
        die('Method disconnect of class Database is not ' .
            'implemented.');
    }

    /***
     * Execute a query and return the result
     * @param $sql the query to perform
     * @returns QueryResult
     ***/
    function &query($sql)
    {
        die('Method query of class Database is not implemented.');
    }

    /***
     * Create a transaction and return it. Subclasses can override this method
     * to return an instance of a database-specific transaction class.
     * @returns Transaction
     ***/
    function &createTransaction()
    {
        include_once(ECLIPSE_ROOT . 'Transaction.php');
        return new Transaction($this);
    }

    // ACCESSORS

    /***
     * Get the internal link identifier; this is a protected method.
     * @returns int
     * @protected
     ***/
    function getLink()
    {
        return $this->link;
    }

    /***
     * Get the host the database is running on
     * @returns string
     ***/
    function getHost()
    {
        return $this->host;
    }

    /***
     * Get the name of the database
     * @returns string
     ***/
    function getName()
    {
        return $this->name;
    }

    /***
     * Check if a connection with the database has been established
     * @returns bool
     ***/
    function isConnected()
    {
        return ($this->link != 0);
    }

    /***
     * Get the last error message produced by the database
     * @returns string
     ***/
    function getErrorMessage()
    {
        die('Method getErrorMessage of class Database is not ' .
            'implemented.');
    }

}

/***
 * Database result types; results can be returned as an indexed array, an
 * associative array, or both. The latter (ECLIPSE_DB_BOTH) is the default.
 ***/
define('ECLIPSE_DB_NUM'  , 1);
define('ECLIPSE_DB_ASSOC', 2);
define('ECLIPSE_DB_BOTH' , 3);

 ***/
class QueryResult {

    // DATA MEMBERS

    /***
     * The database object
     * @type Database
     ***/
    var $database;

    /***
     * The internal result identifier
     * @type int
     ***/
    var $resultId;

    // CREATORS

    /***
     * Construct a new QueryResult-object
     * @private
     * @param $database the database the query was executed on
     * @param $resultId an internal result identifier
     ***/
    function QueryResult(&$database, $resultId)
    {
        $this->database =& $database;
        $this->resultId =  $resultId;
    }

    // MANIPULATORS

    /***
     * Clear the result data from memory; this method need only be called if
     * memory usage is high in a single script. After calling this method, the
     * result can no longer be accessed.
     * @returns void
     ***/
    function clear()
    {
        die('Method clear of class QueryResult is not ' .
            'implemented.');
    }

    // ACCESSORS

    /***
     * Get the internal result identifier; this is a protected method.
     * @returns int
     * @protected
     ***/
    function getResultId() 
    {
        return $this->resultId;
    }

    /***
     * Get a reference to the database
     * @returns Database
     ***/
    function &getDatabase()
    {
        return $this->database;
    }

    /***
     * Check if the query was executed successfully
     * @returns bool
     ***/
    function isSuccess()
    {
        return ($this->resultId != 0);
    }

    /***
     * Get the error message; useful in case isSuccess() returns
     * false. Returns the empty string if there was no error.
     * @returns string
     ***/
    function getErrorMessage() 
    {
        die('Method getErrorMessage of class QueryResult is ' .
            'not implemented');
    }

    /***
     * Get the number of rows in the result for a SELECT-query
     * @returns int
     ***/
    function getRowCount() 
    {
        die('Method getRowCount of class QueryResult is not ' .
            'implemented.');
    }

    /***
     * Get the row at the specified index for a SELECT-query. The
     * optional argument $type defines how the row should be 
     * retrieved: as an indexed array (ECLIPSE_DB_NUM), an 
     * associative array (ECLIPSE_DB_ASSOC) or as both an indexed
     * and an associative array (ECLIPSE_DB_BOTH). The latter is
     * the default.
     * @param $index the index of the row to retrieve
     * @param $type how the row should be retrieved
     * @returns array
     ***/
    function getRow($index, $type = ECLIPSE_DB_BOTH) 
    {
        die('Method getRow of class QueryResult is not ' .
            'implemented.');
    }
}
?>
