<?php
// scr_08_06.php
 ***/
class MyDatabase extends Database 
{
    // CREATORS

    /***
     * Prepare a new database connection on the specified host. If the
     * host is left empty, the localhost is used. To use sockets, specify
     * the path to the socket as the hostname (prepended with ':')
     * @param $name the name of the database
     * @param $host the host the database is running on
     ***/
    function MyDatabase($name, $host = '') 
    {
        $this->Database($name, $host);
    }

    // MANIPULATORS

     /***
     * @returns bool
     ***/
    function connect($username, $password, $type = ECLIPSE_DB_NON_PERSISTENT) 
    {
        $this->setLink(
            ($type == ECLIPSE_DB_PERSISTENT)
                ? mysql_pconnect($this->getHost(), $username, $password)
                : mysql_connect($this->getHost(), $username, $password)
        );
        mysql_select_db($this->getName(), $this->getLink());
        return $this->isConnected();
    }

    /***
     * @returns void
     ***/
    function disconnect() 
    {
        mysql_close($this->getLink());
        $this->setLink(0);
    }

    /***
     * @returns MyQueryResult
     ***/
    function &query($sql) 
    {
        return new MyQueryResult($this, mysql_query($sql, $this->getLink()));
    }

    /***
     * @returns MyTransaction
     ***/
    function &createTransaction()
    {
        include_once(ECLIPSE_ROOT . 'MyTransaction.php');
        return new MyTransaction($this);
    }

    // ACCESSORS

    /***
     * @returns string
     ***/
    function getErrorMessage() 
    {
        return mysql_error($this->getLink());
    }
}

/***
 ***/
class MyQueryResult extends QueryResult 
{
    // DATA MEMBERS

    /***
     * The optional error message
     * @type string
     ***/
    var $errorMessage;

    /***
     * The current row index
     * @type int
     ***/
    var $currentRow;

    // CREATORS

    function MyQueryResult(&$database, $resultId) 
    {
        $this->QueryResult($database, $resultId);
        $this->currentRow   = 0;
        $this->errorMessage = ($resultId !== false) 
                            ? '' 
                            : $database->getErrorMessage();
    }

        // MANIPULATORS

    /***
     * @returns void
     ***/
    function clear() 
    {
        mysql_free_result($this->getResultId());
    }

    // ACCESSORS

    /***
     * @returns string
     ***/
    function getErrorMessage() 
    {
        return $this->errorMessage;
    }

    /***
     * @returns int
     ***/
    function getRowCount() 
    {
        return mysql_num_rows($this->getResultId());
    }

    /***
     * @returns array
     ***/
    function getRow($index, $type = ECLIPSE_DB_BOTH) 
    {
        if ($index != $this->currentRow) 
        {
            mysql_data_seek($this->getResultId(), $index);
        }
        $this->currentRow = $index + 1;
        switch ($type)
        {
            case ECLIPSE_DB_ASSOC:
                return mysql_fetch_assoc($this->getResultId());
            case ECLIPSE_DB_NUM:
                return mysql_fetch_row($this->getResultId());
            case ECLIPSE_DB_BOTH:
            default:
                return mysql_fetch_array($this->getResultId());
        }
    }
}
?>
