package shop;

import pool.*;
import catalogue.*;

public class CatalogueServer extends pool.Server {

  private CatalogueServerRemote serv;
  private MRUCache	        mrucache;

  public CatalogueServer( CatalogueServerRemote obj, ServerPool pool, MRUCache cache) {
    super(pool);
    serv = obj;
    mrucache = cache;
  }

  public ProductInfo findByPrimaryKey(String id) 
				throws java.sql.SQLException, java.rmi.RemoteException {
	ProductInfo result;
    result = (ProductInfo) mrucache.get( id);
    if ( result == null ) {
       CatalogueServer server =  getCatalogueServer() ;
		result = server.findByPrimaryKey(id);
       server.close();     
		cache.put(id,result);
    }
    return result;
  }

}
