package shop;

import pool.*;
import cache.*;
import catalogue.*;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import oracle.aurora.jndi.sess_iiop.ServiceCtx;

public class CatalogueServerPool extends pool.ServerPool {

  private ServiceCtx  		  service;
  private String      		  url = /test/CatalogueServer";
  private int 			  counter;
  private cache.MRUCache          cache;
  private CatalogueServerPool     instance = new CatalogueServerPool() ;

  public static CatalogueServerPool getInstance(){
     return instance ;
  }

  protected CatalogueServerPool() {
    cache = new cache.MRUCache(10);
    env = new Hashtable();
    Hashtable env = new Hashtable();
    env.put(javax.naming.Context.URL_PKG_PREFIXES, "oracle.aurora.jndi");
    Context ic = new InitialContext(env);
    service = (ServiceCtx) ic.lokup("sess_iiop://localhost:2481:ora81");
  }

  public synchronized int getCounter() { return i++;  }

/* linstanciation des EJB instances se fait dans des sessions spares */

  public Server createServer() {
    CatalogueServerHome    home;
    CatalogueServerRemote  server;
    try {
      SessionCtx sess = 
			(SessionCtx) service.createSubcontext(":session"+ getCounter());
      sess.login("ct99","ct99", null);
      home =  (CatalogueServerHome) sess.activate(url);
      server = home.create();
    } catch (Exception ex) { }
    return  new CatalogueServer ( server, this, cache);
  }

  public CatalogueServer getCatalogueServer() {
     return (CatalogueServer) getServer();
  }

}

