package shop;

import pool.*;
import customer.*;

public class CustomerServer extends pool.Server {

  private CustomerServerRemote serv;

  public CustomerServer( CustomerServerRemote obj, ServerPool pool) {
    super(pool);
    serv = obj;
  }

  public void delete(Customer cust)
            throws java.sql.SQLException, java.rmi.RemoteException {
     serv.delete(cust.getCustomerInfo());
  }

  public void findByLogin(Customer cust, String username, String password)
            throws java.sql.SQLException, java.rmi.RemoteException {
     cust.setCustomerInfo(serv.findByLogin(username, password));
  }

  public int insert(Customer cust)
            throws java.sql.SQLException, java.rmi.RemoteException {
    return  serv.insert(cust.getCustomerInfo());
  }

  public void update(Customer cust)
            throws java.sql.SQLException, java.rmi.RemoteException {
    serv.update(cust.getCustomerInfo());
  }

}
