package shop;

import pool.*;
import customer.*;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import oracle.aurora.jndi.sess_iiop.ServiceCtx;

public class CustomerServerPool extends pool.ServerPool {

  private ServiceCtx  service;
  private String      url = "/test/CustomerServer ";
  private int 			counter;

  public CustomerServerPool() {
    Hashtable env = new Hashtable();
    env.put(javax.naming.Context.URL_PKG_PREFIXES, "oracle.aurora.jndi");
    Context ic = new InitialContext(env);
    service = (ServiceCtx) ic.lokup("sess_iiop://localhost:2481:ora81");
  }

  public synchronized int getCounter() { return i++;  }

/* linstanciation des EJB instances se fait dans des sessions spares */

  public Server createServer() {
    CustomerServerHome    home;
    CustomerServerRemote  server;
    try {
      SessionCtx sess = 
			(SessionCtx) service.createSubcontext(":session"+ getCounter());
      sess.login("ct99","ct99", null);
      home =  (CustomerServerHome) sess.activate(url);
      server = home.create();
    } catch (Exception ex) { }
    return  new CustomerServer( server, this);
  }

  public CustomerServer getCustomerServer() {
     return (CustomerServer) getServer();
  }

}
