package shop;

import java.util.Date;
import java.util.*;
import order.*;
import catalogue.*;
import customer.*;
import javax.naming.Context;
import javax.naming.InitialContext;
import oracle.aurora.jndi.sess_iiop.ServiceCtx;
import org.w3c.dom.*;
import oracle.xml.parser.v2.*;

public class Order {

  private int    	id;
  private Date   	order_date;
  private Date   	ship_date;
  private String 	ship_name;
  private String 	ship_firstname;
  private String 	ship_street;
  private String 	ship_city;
  private String 	ship_zip;
  private CustomerInfo  	customer;
  private Hashtable 		list_items = new Hashtable();
  private CatalogueServerPool 	server_catalog;

  // dfinition des accesseurs SET et GET pour les donnes scalaires

  public void setId(int id) { this.id = id; }
  public int getOrderId() { return this.id; }
  public void setOrderDate(Date orddate) { this.order_date = orddate; }
  public Date getOrderDate() { return this.order_date;}
  public void setShipDate(Date shipdate) { this.ship_date = shipdate;}
  public Date getShipDate() { return this.ship_date; }
  public void setShipName(String shipname) { this.ship_name = shipname; }
  public String getShipName() { return this.ship_name; }
  public void setShipFirstname(String name) { this.ship_firstname = name;}
  public String getShipFirstname() { return this.ship_firstname; }
  public void setShipStreet(String street) { this.ship_street = street; }
  public String getShipStreet() { return this.ship_street; }
  public void setShipCity(String shipcity) { this.ship_city = shipcity; }
  public String getShipCity() { return this.ship_city; }
  public void setShipZip(String ship_zip) { this.ship_zip = ship_zip; }
  public String getShipZip() { return this.ship_zip; }
  public void setProductServer( CatalogueServerPool svr) {server_catalog = svr;}

  // dfinition des accesseurs pour les collections (liste des articles).

  public Enumeration getLineItems() { return list_items.elements(); }

  public LineItemInfo getLineItem(String productid) 
		throws NullPointerException {
    return (LineItemInfo) list_items.get( productid);
  }

  public void setProduct(String productid, float qty) {
    try {
        if (list_items.containsKey(productid)) {
          if ( qty <= 0 ) {
              deleteProduct(productid);
          } else {
              LineItemInfo val = (LineItemInfo) list_items.get(productid);
              val.quantity = qty;
          }
        } else {
          if ( qty > 0 ) {
            ProductInfo prod = getProduct(productid);
            list_items.put(productid, new LineItemInfo(productid, prod.name, prod.price, prod.taxrate, qty, qty));
          }
        }
    } catch (Exception e) { }
  }

  public void addProduct(String productid, float qty) {
    try {
      if (list_items.containsKey(productid)) {
        LineItemInfo val = (LineItemInfo) list_items.get(productid);
        val.quantity += qty;
      } else {
        ProductInfo prod = this.getProduct(productid);
        list_items.put(productid, new LineItemInfo(productid, prod.name, prod.price, prod.taxrate, qty,	qty));
      }
    } catch (Exception e) { }
  }

  public void deleteProduct(String productid) {
    try {
      LineItemInfo val = (LineItemInfo) list_items.remove(productid);
    } catch (NullPointerException e) { }
  }

  public void deleteAll() {
    LineItemInfo val;
    try {
      Enumeration e = list_items.keys();
      while ( e.hasMoreElements() ) {
 		   val = (LineItemInfo) list_items.remove(e.nextElement());
       }
    } catch (NullPointerException e) { }
  }

  public String getTotal() {
    LineItemInfo curr;
    float resultat = 0;
    Enumeration val = list_items.elements();
    while (val.hasMoreElements()) {
        curr = (LineItemInfo) val.nextElement();
        resultat += curr.quantity * curr.price ;
    }
    return String.valueOf(resultat);
  }

public XMLDocument writeXML() {
    XMLDocument doc =  new XMLDocument();
    Element root, elem, items, item;
    try {
      root = doc.createElement("ORDER");
      doc.appendChild(root);
      elem = doc.createElement("ID");
      elem.appendChild(doc.createTextNode( getId() ));
      root.appendChild(elem);
      elem = doc.createElement("CUSTOMER_ID");
      elem.appendChild(doc.createTextNode( customer.id ));
      root.appendChild(elem);
      elem = doc.createElement("ORDER_DATE");
      elem.appendChild(doc.createTextNode( String.valueOf(getOrderDate()) ));
      root.appendChild(elem);
      elem = doc.createElement("SHIP_DATE");
      elem.appendChild(doc.createTextNode( String.valueOf(getShipDate()) ));
      root.appendChild(elem);
      elem = doc.createElement("SHIP_NAME");
      elem.appendChild(doc.createTextNode( getShipName() ));
      root.appendChild(elem);
      elem = doc.createElement("SHIP_FIRSTNAME");
      elem.appendChild(doc.createTextNode( getShipFirstname() ));
      root.appendChild(elem);
      elem = doc.createElement("SHIP_STREET");
      elem.appendChild(doc.createTextNode( getShipStreet() ));
      root.appendChild(elem);
      elem = doc.createElement("SHIP_CITY");
      elem.appendChild(doc.createTextNode( getShipCity() ));
      root.appendChild(elem);
      elem = doc.createElement("SHIP_ZIP");
      elem.appendChild(doc.createTextNode( getShipZip() ));
      root.appendChild(elem);
      items = doc.createElement("LINE_ITEMS");
      root.appendChild(items);
      LineItemInfo curr;
      Enumeration e = this.getLineItems();
      while ( e.hasMoreElements()) {
        curr = (LineItemInfo) e.nextElement();
        item = doc.createElement("LINE_ITEM_TYPE");
        items.appendChild(item);
        elem = doc.createElement("PRODUCT_ID");
        elem.appendChild(doc.createTextNode( curr.product_id));
        item.appendChild(elem);
        elem = doc.createElement("QUANTITY");
        elem.appendChild(doc.createTextNode(String.valueOf(curr.quantity) ));
        item.appendChild(elem);
        elem = doc.createElement("DISCOUNT");
        elem.appendChild(doc.createTextNode(String.valueOf(curr.discount) ));
        item.appendChild(elem);
      }
    } catch (Exception e) {}
    return doc;
  }

  public ProductInfo getProduct(String id) throws Exception {
 	CatalogueServer srv =  
                  CatalogueServerPool.getInstance().getCatalogueServer();
	ProductInfo prod = srv.findByPrimaryKey(id);
	Srv.close();
	Return prod ;
  }
}
