package shop;

import pool.*;
import order.*;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import oracle.aurora.jndi.sess_iiop.ServiceCtx;

public class OrderServerPool extends pool.ServerPool {

  private ServiceCtx  service;
  private String      url = "/test/OrderServer";
  private int 			counter;

  public OrderServerPool() {
    Hashtable env = new Hashtable();
    env.put(javax.naming.Context.URL_PKG_PREFIXES, "oracle.aurora.jndi");
    Context ic = new InitialContext(env);
    service = (ServiceCtx) ic.lokup("sess_iiop://localhost:2481:ora81");
  }

  public synchronized int getCounter() { return i++;  }

/* linstanciation des EJB se fait dans des sessions spares */

  public Server createServer() {
    OrderServerHome    home;
    OrderServerRemote  server;
    try {
      SessionCtx sess = 
			(SessionCtx) service.createSubcontext(":session"+ getCounter());
      sess.login("ct99","ct99", null);
      home =  (OrderServerHome) sess.activate(url);
      server = home.create();
    } catch (Exception ex) { }
    return  new OrderServer( server, this);
  }

  public OrderServer getOrderServer() {
     return (OrderServer) getServer();
  }

}
