package shop;
import pool.*;
import cache.*;
import page.*;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import oracle.aurora.jndi.sess_iiop.ServiceCtx;

public class XMLPageServer extends cache.MRUCache {
  private String                  url;
  private Hashtable               env;
  private pageServerHome          home;
  private static XMLPageServer    instance = new XMLPageServer();

  public static XMLPageServer getXMLPageServer() {
    return _instance;
  }

  protected XMLPageServer() {
	super(10);
    env = new Hashtable();
    env.put(javax.naming.Context.URL_PKG_PREFIXES, "oracle.aurora.jndi");
    env.put(javax.naming.Context.SECURITY_PRINCIPAL, "ct99");
    env.put(javax.naming.Context.SECURITY_CREDENTIALS, "ct99");
    env.put(javax.naming.Context.SECURITY_AUTHENTICATION, ServiceCtx.NON_SSL_LOGIN);
    url = "sess_iiop://localhost:2481:ora81/test/pageServer";
    createHome();
  }

/* notre EJB ntant pas appel  effectuer des modifications, insertions ou destructions de donnes (lecture seule), nous pouvons nous permettre de crer les diverses instances au sein de la mme session SQL. Un mme EJB Home peut donc tre utilis pour crer les instances (fonctionnement standard des EJB) */

  public void  createHome() {
    try {
      Context  ic = new InitialContext(env);
      home =  (pageServerHome) ic.lookup(url);
    } catch (Exception ex) { }
  }
  public String get(String id) {
    String result;
    result = (String) cache.get(id);
    if ( result == null ) {
       try {
	       pageServerRemote server = home.create();
			 result = server.FindByPrimaryKey(id);
           cache.put(id,result);
       } catch (Exception ex) { }
    }
    return result;
  }

}
