
drop user ct99 cascade;

create user ct99 identified by ct99
default tablespace users
temporary tablespace temp
quota unlimited on users
quota unlimited on temp;

grant dba on ct99;



connect ct99/ct99;


create table orders (
	id 		number(10) not null,
	customer_id	number(10),
	order_date	date,
	ship_date	date,
	ship_name	varchar2(20),
	ship_firstname	varchar2(20),
	ship_street	varchar2(80),
	ship_city	varchar2(40),
	ship_zip	varchar2(10)
);


create sequence order_id;


create table customers (
	id 		number(10) not null,
	name		varchar2(20),
	password	varchar2(20),
	firstname	varchar2(20),
	email		varchar2(40),
	street		varchar2(80),
	city		varchar2(40),
	zip		varchar2(10)
);

create sequence customer_id;


create table products (
	id		number(10),
	name		varchar2(40),
	description	varchar2(200),
	price		number(10,2),
	taxrate		number(10,2),
	image		varchar2(20)
);

create sequence product_id;


create table line_items (
	order_id	number(10),
	product_id	number(10),
	quantity	number(10,2),
	discount	number(10,2)
);

create sequence page_id;

create table pages (
	id 		number(10),
	product_id	number(10),
	origine_x	number(10),
	origine_y	number(10),
	width		number(10),
	heigth		number(10)
);

create view order_items ( order_id, product_id, name, price, taxrate, quantity, discount) as
select order_id, product_id, name, price, taxrate, quantity, discount from line_items, products where product_id=id;





insert into products (id,name,description,price,taxrate,image) 
 values (1,'Sofa Minesota','This product exists in three different colors (red, blue, white).', 800, 20, 'he150min.gif');

insert into products (id,name,description,price,taxrate,image) 
 values (2,'Sofa Rotonde','This appliance takes benefit from new technologies in an old design of seventies.', 1000, 20, 'he154ten.gif');

insert into products (id,name,description,price,taxrate,image) 
 values (3,'Sofa Anglade','This product exists in three different colors (red, blue, white).', 1200, 20, 'he152ala.gif');



insert into products (id,name,description,price,taxrate,image)
 values (4,'Micro Wave','This product exists in three different colors (red, blue, white), Power 1800 Watt.', 200, 20, 'hg_1115506.gif');

insert into products (id,name,description,price,taxrate,image)
 values (5,'Robot','This appliance takes benefit from new technologies in an old design of seventies.', 40, 20, 'hd_1115506.gif');

insert into products (id,name,description,price,taxrate,image)
 values (6,'Toaster','This product exists in three different colors (red, blue, white), Power 1800 Watt.', 100, 20, 'bg_1115506.gif');

insert into products (id,name,description,price,taxrate,image)
 values (7,'Vacuum Cleaner','This appliance takes benefit from new technologies in an old design of seventies.', 200, 20, 'cb_1115506.gif');



insert into products (id,name,description,price,taxrate,image)
 values (8,'Clothes-Press','This product exists in three different colors (red, blue, white).', 200, 20, 'ch_E1115503.gif');

insert into products (id,name,description,price,taxrate,image)
 values (9,'Bench','This appliance takes benefit from new technologies in an old design of seventies.', 150, 20, 'cb_E1115503.gif');

insert into products (id,name,description,price,taxrate,image)
 values (10,'Arm-Chair','This product exists in three different colors (red, blue, white).', 300, 20, 'g_E1115503.gif');


//pages

insert into pages (id, product_id, origine_x, origine_y, width, heigth) values (1,9,450,70, 270,270);
insert into pages (id, product_id, origine_x, origine_y, width, heigth) values (1,8,90,50, 270,270);
insert into pages (id, product_id, origine_x, origine_y, width, heigth) values (1,10,360, 300, 270,270);

insert into pages (id, product_id, origine_x, origine_y, width, heigth) values (2,4, 70, 30, 280, 160);
insert into pages (id, product_id, origine_x, origine_y, width, heigth) values (2,5,440, 30, 300, 150);
insert into pages (id, product_id, origine_x, origine_y, width, heigth) values (2,6,110, 250, 200, 350);
insert into pages (id, product_id, origine_x, origine_y, width, heigth) values (2,7,430, 240,300, 400);

insert into pages (id, product_id, origine_x, origine_y, width, heigth) values (3,1,90, 90, 270, 270);
insert into pages (id, product_id, origine_x, origine_y, width, heigth) values (3,2,450, 70, 270, 270);
insert into pages (id, product_id, origine_x, origine_y, width, heigth) values (3,3,350, 300, 270, 270);


create view catalogue ( page_id,
			product_id,
			name,
			price,
			image,
			description,
			origine_x,
			origine_y,
			width,
			heigth) as  
select	a.id,
	p.id,
	p.name,
	p.price,
	p.image,
	p.description,
	a.origine_x,
	a.origine_y,
	a.width,
	a.heigth
from products p, pages a where
p.id = a.product_id;


