import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import java.util.*;
import org.w3c.dom.*;
import oracle.xml.parser.v2.*;
import java.net.*;
import shop.*;

public class PageServer extends HttpServlet {

  XSLStylesheet xsl;
  XMLPageServer server;

  public void init(ServletConfig config) throws ServletException {
    super.init(config);
    DOMParser parser = new DOMParser();
    parser.setPreserveWhitespace(true);
    try {
         URL xslURL = new URL("file:///e:/stylesheet/page.xsl");
         parser.parse(xslURL);
         XMLDocument xsldoc = parser.getDocument();
         xsl = new XSLStylesheet(xsldoc, xslURL);
         server = XMLPageServer.getInstance();
    } catch( Exception e) {
        System.out.println("problem to initialize");
    }
  }

  public void service(HttpServletRequest req, HttpServletResponse res) 
			throws ServletException, IOException {
    XMLDocument xml, out;
    DOMParser parser;
    XSLProcessor processor;
    res.setContentType("text/html");
    PrintWriter rout = new PrintWriter (res.getOutputStream());
    String id = req.getParameter("id");
      try {
         parser = new DOMParser();
         processor = new XSLProcessor();
         parser.parse( new CharArrayReader(server.get(id).toCharArray()));
         xml = parser.getDocument();
         DocumentFragment result = processor.processXSL(xsl, xml);
         out = new XMLDocument();
         Element root = out.createElement("root");
         out.appendChild(root);
         root.appendChild(result);
         out.print(rout);
      } catch (Exception e) {
         e.printStackTrace();
      }
    rout.close();
  }

  public String getServletInfo() { return "shop.PageServer Information"; }
}


