import pool.*;
import cache.*;
import java.util.*;

public class Notifier extends Thread {

  public  int counter;				// squence identifiant les tches
  public  int countertask;			// compteur des tches termines
  private MRUCache resulttable;	// table des rsultats (cache)
  private Hashtable requesttable; // table des requtes en cours
  private ServerPool serverpool;  // gestionnaire du pool serveurs
  private LinkedList taskstack;	// table des tches non affectes

  public Notifier() {
     this.counter = 0;
     this.countertask = 0;
     this.resulttable  = new MRUCache(20);
     this.requesttable = new Hashtable();
     this.taskstack    = new LinkedList();

     this.setDaemon(true);
     this.start();
  }

  // associe au Notifier le gestionnaire de pool de serveurs correspondant

  public void setServerPool(ServerPool pool)  {
    this.serverpool = pool;
  }

  public void setCacheSize(int size)  {
    this.resulttable.setCacheSize(size);
  }

  public synchronized int nextCounter() {
     int result = counter++;
     return result;
  }

 /* 
Dtecte si une requte similaire est en cours dexcution. Si tel est le cas, la tche en cours de ralisation est rcupre, sinon elle est cre. On invoque alors sur la tche la mthode  serverOK()  pour mettre le client en attente (thread courant qui a appel  sendrequest() ).

Laccs  la table des requtes en cours est critique. Un seul client  la fois peut y accder (opration lecture et destruction en parallle), cest pourquoi une section de code est synchronise (recherche-rcupration ou ajout du tche). Cette synchronisation doit tre la plus courte possible car tous les clients ont besoin de cette table. 

Un autre problme peut cependant se poser. Une tche pralablement lance peut aboutir et les clients peuvent tre notifis, alors que le client courant na pas encore t arrt (il risque dtre mis en attente perptuellement dun rsultat qui ne viendra plus car la tche est termine). Les mthodes  addClient ,  removeClient  et la synchronisation sur  Task  rsolvent ce problme. Ds que lon manipule une tche, le nombre de clients en cours sur celle-ci est incrment. Il sera dcrment lorsquon arrtera effectivement le client (synchronisation donc laccs unique par un client est garanti). Voir  addResult()  pour la notification des clients.
*/

  public Task sendRequest(Request req) {
     Task task;
     boolean isnew = false;
     Object key = req.parameter;

     synchronized(requesttable) {
       if (requesttable.containsKey(key)) {
          task = (Task1) requesttable.get(key);
       } else {
          isnew = true;
          task = new Task(nextCounter(), req, this);
          requesttable.put(key, task);
       }
       task.addClient();
     }

     if (isnew) { taskstack.addLast(task); }

     synchronized(task) {
       task.removeClient();
       task.serverOK();
     }
     return task;
  }

/* 
La cration de la tche est force. La requte est donc traite exclusivement  la diffrence de la mthode prcdente  sendRequest()  qui sefforce de mutualiser les travaux.
*/

  public Task sendRequestExclusive(Request req) {
     Task task = new Task(nextCounter(), req, this);

     synchronized(requesttable) {
       requesttable.put(req.parameter, task);
       task.addClient();
     }

     taskstack.addLast(task);

     synchronized(task) {
       task.removeClient();
       task.serverOK();
     }
     return task;
  }

/*
Rcupre le rsultat dans le cache et vrifie sil nest pas trop vieux par rapport  la tolrance prcise dans la requte.
*/

  public Task getTaskFromCache(Request req) {
     Task task = null;
     synchronized(resulttable) {
       try  {
         task = (Task) resulttable.get(req.parameter);
       } catch(Exception e) {
         System.out.println(e.getMessage());
       }
     }
     if ((task != null) &&
          ((System.currentTimeMillis() - task.birth) > req.tolerance)) {
        task = null;
     }
     return task;
  }

/*
Dtermine la politique  adopter en fonction du type de requte (share, exclusive, cache)
*/

  public Task getResult(Request req) {
     Task1 task = null;
     switch(req.mode) {
       case Request.exclusive :
           task = sendRequestExclusive(req);
       case Request.shared :
           if (req.tolerance > 0) {  task = getTaskFromCache(req);  }
           if (task == null) {  task = sendRequest(req); }
     }
     return task;
  }

/* 
Cest uniquement lorsque le nombre de clients en cours de manipulation sur la tche est nul et quelle ne figure plus dans la table des requtes que la notification des clients peut avoir lieu (certitude que tous les clients associs  cette tche sont en attente).
*/

  public void addResult(Task t) {
     synchronized(resulttable) {
        resulttable.put(t.request.parameter, t);
        countertask++;
     }   
     synchronized(requesttable) {
        requesttable.remove(t.request.parameter);
     }
     while (t.nbclient != 0) {}
     t.resultOK();
  }

/*
Notifier implmente un thread propre charg de rcuprer au fil de leau les tches soumises via  sendRequest()  par les clients dans  taskstack , et de leur allouer un serveur (remarque : ce mcanisme aurait trs bien pu tre cod  lextrieur de  Notifier  dans un objet ddi).
*/

 public void run() {
     Task task;
     while(true) {
        try {
           if (taskstack.size() > 0) {
             for (int i=0; i<taskstack.size();) {
                task = (Task) taskstack.removeFirst();
                Server server = serverpool.getServer();
                server.setTask(task);
             }
           } else {
             sleep(10);
           }
        } catch(Exception e) {  }
     }
  }

}
