import java.net.*;
import pool.*;
import org.w3c.dom.*;
import oracle.xml.parser.v2.*;

public class XMLServer extends pool.Server implements Runnable {

  private  Task    task;
  private  Thread  thread;

  private  URL     		xmlurl
  private  DOMParser     parser;

  public XMLServer(ServerPool pool) {
    super(pool);
    init();
  }

  public void setThread(Thread t) { this.thread = t; }
  public Thread getThread() {  return this.thread; }

  public void init() {
     task = null;
     parser = new DOMParser();
  }

  public final void process() {
     try {
       xmlURL = new URL((String) task.request.parameter);
       parser.parse(xmlURL);
       task.status = Task.ok;
       task.setResponse(parser.getDocument());
     } catch (Exception e) {
       task.status = Task.ko;
     }
  }

  public void run() {
     while(true) {
         if (task != null) {
            process();
            this.task.notifier.addResult(task);
            this.task = null;
            this.close();
         }
         thread.suspend();
     }
  }

  public void setTask(Task1 task) {
      this.task = task;
      this.thread.resume();
  }

}
