package cache;

import java.util.*;
import java.io.*;

public class MRUCache extends Hashtable {

  private int         cachesize;
  private Vector      mrulist;

  public MRUCache(int max) {
    cachesize = max;
    mrulist   = new Vector();
  }

  public MRUCache() {
    this(10);
  }

  public void setCacheSize(int max) { cachesize = max; }
  public int getCacheSize() { return cachesize; }

  public synchronized Object put(Object id, Object obj) {
    if (!this.containsKey(id)) {
        if (mrulist.size() >= cachesize) {
          super.remove(mrulist.elementAt(cachesize));
          mrulist.removeElementAt(cachesize);
        }
    } else {
      mrulist.removeElement(id);
    }
    super.put(id, new CachedObject(obj));
    mrulist.insertElementAt(id,0);
    return obj;
  }

  public synchronized Object get(Object id) {
    CachedObject obj;
    Object result = null;
    if (this.containsKey(id)) {
      obj = (CachedObject) super.get(id);
      mrulist.removeElement(id);
      if (obj.loadingTime() > obj.lastModified()) {
          result = obj.getContents();
          mrulist.insertElementAt(id,0);
      } else {
          super.remove(id);
      }
    }
    return result;
  }


  public synchronized Object remove(Object id) {
     Object obj;
     obj = super.remove(id);
     mrulist.removeElement(id);
     return obj;
  }

}
