package catalogue;

import java.rmi.RemoteException;
import javax.ejb.*;
import java.sql.*;

public class CatalogueServer implements SessionBean {

  private Connection conn;
  private PreparedStatement pstmt = null;

  public CatalogueServer() {}

  public void ejbCreate() throws RemoteException, CreateException {
    try {
        conn = new oracle.jdbc.driver.OracleDriver().defaultConnection();
        pstmt = conn.prepareStatement("select id, name, description, 
													price, taxrate from products 
													where id = ? ");
    } catch( SQLException e) {}
  }

  public void ejbActivate() throws RemoteException {}

  public void ejbPassivate() throws RemoteException {}

  public void ejbRemove() throws RemoteException {}

  public void setSessionContext(SessionContext ctx) throws RemoteException {}

  public ProductInfo findByPrimaryKey(String id) 
	throws SQLException, RemoteException  {
      	ProductInfo c = null;     
		pstmt.setString(1, id);
       ResultSet rset = pstmt.executeQuery();
       rset.next();
      	c = new ProductInfo(	rset.getString(1), rset.getString(2),
                            rset.getString(3), rset.getFloat(4),
                            rset.getFloat(5));
       rset.close();
      return c;
  }
  public void finalize() throws SQLException{
      pstmt.close();
  }

}


