package customer;

import java.rmi.RemoteException;
import javax.ejb.*;
import java.sql.*;

public class CustomerServer implements SessionBean {

  private Connection conn;
  private String sql = "select id, name, password, firstname, email,
							  street, city, zip from customers";
  public CustomerServer() {}

  public void ejbCreate() throws RemoteException, CreateException {
    try {
        conn = new oracle.jdbc.driver.OracleDriver().defaultConnection();
    } catch( SQLException e) {}
  }

  public void ejbActivate() throws RemoteException {}

  public void ejbPassivate() throws RemoteException {}

  public void ejbRemove() throws RemoteException {}

  public void setSessionContext(SessionContext ctx) throws RemoteException {}

  public CustomerInfo findByLogin(String  username, String password) 
	throws SQLException, RemoteException {
      CustomerInfo c = null;
      Statement stmt = conn.createStatement();
      try {
          ResultSet rset = stmt.executeQuery( sql + " where email = '" + 
									username + "' and password = '"+ password+"'");
          rset.next();
          c = new CustomerInfo( String.valueOf(rset.getInt(1)),
                                rset.getString(2),
                                rset.getString(3),
                                rset.getString(4),
                                rset.getString(5),
                                rset.getString(6),
                                rset.getString(7),
                                rset.getString(8));
          rset.close();
      } finally {
          stmt.close();
      }
      return c;
  }

  public int insert(CustomerInfo cust) 
	throws SQLException, RemoteException {
    	int id = getCustomerId();
    PreparedStatement pstmt = null;
    try {
        pstmt = conn.prepareStatement("insert into customers ( id, name, 
												password, firstname, email, street, 
												city, zip) values (?,?,?,?,?,?,?,?)");
        pstmt.setInt(1, id);
        pstmt.setString(2, cust.name);
        pstmt.setString(3, cust.password);
        pstmt.setString(4, cust.firstname);
        pstmt.setString(5, cust.email);
        pstmt.setString(6, cust.street);
        pstmt.setString(7, cust.city);
        pstmt.setString(8, cust.zip);
        pstmt.executeUpdate();
    } finally {
        pstmt.close();
    }
    return id;
  }

  public void update(CustomerInfo cust) 
	throws SQLException, RemoteException {
    PreparedStatement pstmt = null;
    try {
        pstmt = conn.prepareStatement("update customers set name = ? , 
									password = ?, firstname = ?, email = ?, 
									street = ?, city = ?, zip = ? where id = ?");
        pstmt.setString(1, cust.name);
        pstmt.setString(2, cust.password);
        pstmt.setString(3, cust.firstname);
        pstmt.setString(4, cust.email);
        pstmt.setString(5, cust.street);
        pstmt.setString(6, cust.city);
        pstmt.setString(7, cust.zip);
        pstmt.setInt(8, Integer.parseInt( cust.id));
        pstmt.executeUpdate();
    } finally {
        pstmt.close();
    }
  }

  public void delete(CustomerInfo cust) 
	throws SQLException, RemoteException{
    PreparedStatement pstmt = null;
    try {
        pstmt = conn.prepareStatement("delete from customers where id=?");
        pstmt.setInt(1, Integer.parseInt( cust.id));
        pstmt.executeUpdate();
    } finally {
        pstmt.close();
    }
  }

  public int getCustomerId() throws SQLException {
    int resultat;
    Statement stmt = conn.createStatement();
    try {
        ResultSet rset = stmt.executeQuery("select customer_id.nextval 
														 from dual");
        rset.next();
        resultat = rset.getInt(1);
        rset.close();
    } finally {
        stmt.close();
    }
    return resultat;
  } 

}
