package pool;

public abstract class Server {

  private long        timestamp;
  private boolean     inuse;
  private ServerPool  pool;

  protected Server(ServerPool pool) {
    this.pool       = pool;
    this.inuse      = false;
    this.timestamp  = 0;
  }

  public synchronized boolean lease() {
     if (inuse) {
        return false;
     } else {
        inuse = true;
        timestamp = System.currentTimeMillis();
        return true;
     }
  }

  public boolean inUse() {  return inuse;  }

  public long getLastUse() {  return timestamp;  }

  public void close() {  pool.returnServer(this);  }

  public void expireLease() { inuse = false;  }

  public boolean validate() { return true;  }

  public abstract void setTask(Task task);

}

