

create or replace type line_item_type as object (
	PRODUCT_ID NUMBER(10),
	QUANTITY   NUMBER(10,2),
	DISCOUNT   NUMBER(10,2)
);

create type line_items_type as table of line_item_type;

create type order_type as object (
 ID                NUMBER(10),
 CUSTOMER_ID       NUMBER(10),
 ORDER_DATE        DATE,
 SHIP_DATE         DATE,
 SHIP_NAME         VARCHAR2(20),
 SHIP_FIRSTNAME    VARCHAR2(20),
 SHIP_STREET       VARCHAR2(80),
 SHIP_CITY         VARCHAR2(40),
 SHIP_ZIP          VARCHAR2(10),
 LINE_ITEMS	   line_items_type
);

create view v_orders of order_type
with object oid ( id) as
select 
	o.id,
	o.customer_id,
	o.order_date,
	o.ship_date,
	o.ship_name,
	o.ship_firstname,
	o.ship_street,
	o.ship_city,
	o.ship_zip,
	cast( multiset( select  l.product_id,
				l.quantity,
				l.discount
			from line_items l
			where l.order_id = o.id)
	      as line_items_type
	    )
from orders o;


create or replace trigger ins_v_orders instead of insert on v_orders
declare
   order_id NUMBER(10);
   items line_items_type;
   curr_item  line_item_type;
begin
   order_id := :NEW.id;
   items := :NEW.line_items;
   insert into orders (
	id,
	customer_id,
	order_date,
	ship_date,
	ship_name,
	ship_firstname,
	ship_street,
	ship_city,
	ship_zip
   ) values (
	:NEW.id,
	:NEW.customer_id,
	:NEW.order_date,
	:NEW.ship_date,
	:NEW.ship_name,
	:NEW.ship_firstname,
	:NEW.ship_street,
	:NEW.ship_city,
	:NEW.ship_zip
   );
   for i in items.FIRST..items.LAST loop
	curr_item := items(i);
   insert into line_items (order_id, product_id, quantity, discount) values
			  (order_id,curr_item.product_id,curr_item.quantity,curr_item.discount);
   end loop;
   null;
end;
/