import java.net.*;
import org.w3c.dom.*;
import oracle.xml.parser.v2.*;

public class Customer1 extends Thread {

  long time;
  Request[] target;
  Response[] response;
  XMLDocument xmldoc, styledoc;

  public Customer1() { }

  public void run() {
     long begin, end;
     Task1 task;
     int nb = target.length;
     response = new Response[nb];
     target = new Request[1];

     for (int i=0; i<nb; i++) {
       
      // appel au serveur mullti-thread

      begin = System.currentTimeMillis();
      task =  TransformEngine.getResponse(target[0]);
      end = System.currentTimeMillis();

  	  // rcupration de la rponse

      response[i] = new Response();
      response[i].ident    = i;
      response[i].result   = task.getResponse();
      response[i].status   = task.status;
      response[i].duration = end - begin;

      try {
        sleep(time);
      } catch (InterruptedException e) {
        System.out.println("Abandon");
      }    

     }
  }

// Chargement du scnario  partir dun document XML

  public void init(String scenariofile, long time) {
     Element n;
     String ident, sheet, toler, xpage, wtime, xmode;
     NodeList nl, nl1;  

     this.time = time;
     try {
       DOMParser parser = new DOMParser();

       parser.parse(new URL(scenariofile));
       styledoc = parser.getDocument();

		// rcupration des tags REQUEST prsents dans le document XML

       nl = styledoc.getElementsByTagName("REQUEST");

       target = new Request[ nl.getLength() ];

		// construction des requtes  jouer

       for (int i=0; i<nl.getLength(); i++) {
          nl1 =  nl.item(i).getChildNodes();
          ident =  nodeValue(nl1,0);   // ID
          sheet =  nodeValue(nl1,1);   // URL STYLESHEET
          toler =  nodeValue(nll,2);   // TOLERANCE
          xpage =  nodeValue(nll,3);   // URL XML SOURCE
          wtime =  nodeValue(nll,4);   // WAITING TIME BEFORE NEXT REQUEST
          xmode =  nodeValue(nll,5);   // MODE (EXCLUSIVE / SHARED)

          target[i] = new Request(new Parameter(xpage,sheet) , 
											 Long.parseLong(toler),xmode.charAt(0));

       }      
     } catch (Exception e) {
        System.out.println("erreur au chargement du scenario" );
     }     
  }

  public String nodeValue(NodeList nl, int i) {
	return nl.item(i).getFirstChild().getNodeValue();
  }

  public long getTime() {
    long total = 0;
    for (int i=0; i<response.length; i++) {
         total += response[i].duration;
    }
    return total;
  }

  public long getKO() {
    int total = 0;
    for (int i=0; i<response.length; i++) {
       if (response[i].status == Task1.ko) {
          total++;
       }
    }
    return total;
  }

  public int getOccurence() {
    return response.length;
  }

}
