public class Task {

  public int        taskid;		// identifiant de la tche
  public Notifier   notifier;	// rfrence sur le Notifier grant la tche
  public long       birth;		// date de cration de la tche
  public int        nbclient;  // nb clients attachs mais non en attente
  public char       status;		// tat de la tche (ok / ko)
  public Request    request;	// requte associe
  public Object     response;	// rponse correspondante  la requte

  static final char processing  = '0';
  static final char ok          = '1';
  static final char ko          = '2';

  public Task(int id, Request req, Notifier notifier) {
    this.taskid = id;
    this.request = req;
    this.notifier = notifier;
    this.nbclient = 0;
  }

  public void setResponse(Object doc) {
    this.birth = System.currentTimeMillis();
    this.response = doc;
  }

  public Object getResponse() { return this.response; }

  public synchronized void serverOK() {
    try {
       wait();
    } catch (InterruptedException e) {}
  }

  public synchronized void resultOK() {
    notifyAll();
  }

  public synchronized void addClient() {  this.nbclient++;  }

  public synchronized void removeClient() {  this.nbclient--;  }

}

