import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import java.util.*;
import org.w3c.dom.*;
import oracle.xml.parser.v2.*;

public class TestServlet extends HttpServlet {

    XSLEngine x;
    XMLEngine y;
    TransformEngine z;

  public void init(ServletConfig config) throws ServletException {
    super.init(config);

/*
 Dmarrage des diffrents serveurs lors de linitialisation de la 
 servlet (les serveurs doivent tre dmarrs et stocks dans des variables  
 pour forcer leur maintien en mmoire en raison de la transparence du 
 garbage collecting des Java Virtual Machines).
*/

    x = XSLEngine.getInstance();
    y = XMLEngine.getInstance();
    z = DocumentEngine.getInstance();
  }

  public void doGet(HttpServletRequest req, HttpServletResponse res) 
						throws ServletException, IOException {
    String xmldoc , xsldoc;
    char mode;
    long tolerance;

// Rcupration des valeurs associes aux paramtres ou des valeurs par 
// dfaut.

    xmldoc = getValue(req,"xmldoc","file:///e:/test/dept.xml");
    xsldoc = getValue(req,"xsldoc","file:///e:/test/dept.xsl");
    mode = getValue(req,"mode",String.valueOf(Request.shared)).charAt(0);
    tolerance = Long.parseLong(getValue(req,"tolerance","0"));

// Construction de la requte et envoi au DocumentEgine.

    Request r = new Request(new Parameter(xmldoc,xsldoc),tolerance,mode);
    Task task = DocumentEngine.getResponse(r);

    res.setContentType("text/html");
    PrintWriter out = new PrintWriter (res.getOutputStream());

// Rcupration du rsultat et criture dans le flux de rponse.

    ((XMLDocumentFragment) task.getResponse()).print(out);

    out.close();
  }

  public String getValue(HttpServletRequest req,String name,String defval) {
    String result = null;
    try {
       result = req.getParameter(name);
    } catch (Exception e) { }
    if (result == null) result = defval;
    return result;
  }

}
