import java.net.*;
import pool.*;
import org.w3c.dom.*;
import oracle.xml.parser.v2.*;

public class TransformServer extends pool.Server implements Runnable {

  private Task task;
  private Thread thread;
  private XSLStylesheet xsldoc;
  private XSLProcessor processor;
  private XMLDocumentFragment xmldoc, result;

  public TransformServer(ServerPool pool) {
    super(pool);
    init();
  }

  public void setThread(Thread t) { this.thread = t;  }
  public Thread getThread() { return this.thread; }

  public void init() {
     task = null;
     processor = new XSLProcessor();
  }

  public final void process() {
     String s;
	 Task t;
     try {

// Invocation du serveur de documents XSL

        s =  ((Parameter) task.request.parameter).xsldoc;
        t = XSLEngine.getResult(new Request(s,10000,Request.shared));
        xsldoc =  (XSLStylesheet) t.getResponse();

// Invocation du serveur de documents XML

        s = ((Parameter) task.request.parameter).xmldoc;
        t = XMLEngine.getResult(new Request(s,0,Request.shared));
        xmldoc =  (XMLDocument) t.getResponse();

// Transformation du document XML  laide de la feuille XSL

        result = processor.processXSL(xsldoc, xmldoc);
        task.status = Task.ok;
        task.setResponse(result);
     } catch (Exception e) {
        task.status = Task.ko;
    }
  }

  public void run() {
     while(true) {
         if (task != null) {
            process();
            this.task.notifier.addResult(task);
            this.task = null;
            this.close();
         }
         thread.suspend();
     }
  }

  public void setTask(Task task) {
      this.task = task;
      this.thread.resume();
  }

}
