package pool;

import java.util.*;

public abstract class ServerPool {

  private Vector        servers;
  private ServerReaper  reaper;
  private final int     poolsize = 5;
  private final long    timeout = 3000;

  public ServerPool() {
    servers = new Vector(poolsize);
    reaper  = new ServerReaper(this);
    reaper.start();							// dmarrage du nettoyeur
  }

  public synchronized void reapServers() {
    long stale = System.currentTimeMillis() - timeout;
    Enumeration serverlist = servers.elements();
    while ((serverlist != null) && (serverlist.hasMoreElements())) {
       Server serv = (Server) serverlist.nextElement();
       if ((serv.inUse()) &&
			  (stale > serv.getLastUse()) && (!serv.validate())) {
           removeServer(serv);
       }
    }
  }

  private synchronized void removeServer(Server serv) {
    servers.removeElement(serv);
  }

  public synchronized Server getServer() {
    Server s;
    for (int i=0; i <servers.size(); i++) {
      s = (Server) servers.elementAt(i);
      if (s.lease()) { return s; }
    }
    s = createServer();
    s.lease();
    servers.addElement(s);
    return s;
  }

  public synchronized void returnServer(Server serv) {
    serv.expireLease();
  }

  public abstract Server createServer();

}
