package catalogueServer;

 import catalogue.*;
 import oracle.aurora.jndi.sess_iiop.ServiceCtx;
 import oracle.aurora.AuroraServices.ActivatableObject;
 import javax.naming.*;
 import java.sql.*;
 import java.util.*;

 public class PageImpl extends PageImplBase implements ActivatableObject {

   Product server = null;

   public PageInfo getPage(int pageno) throws SQLError {
     try {
       if (server == null) {
          Hashtable env = new Hashtable ();
          env.put (Context.URL_PKG_PREFIXES, "oracle.aurora.jndi");
          Context ic = new InitialContext(env);
          server = (Product) ic.lookup("sess_iiop://thisSession/test/product");
       }
       ProductInfo[] products = server.getProducts(pageno);
       String id, name;
       #sql {select id,name into :id,:name from pages where id=:pageno };

       return new PageInfo (id, name, products);

    } catch (SQLException e) {
      throw new SQLError (e.getMessage ());
    } catch (NamingException e) {
      throw new SQLError ("Naming Exception: " + e.getMessage ());
    }
  }

  public org.omg.CORBA.Object _initializeAuroraObject () {
    return this;
  }
}


