package catalogueServer;

 import catalogue.*;
 import oracle.aurora.AuroraServices.ActivatableObject;
 import java.sql.*;
 import java.util.Vector;

 #sql iterator ProdIterator (int id, String name, double price);

 public class ProductImpl extends ProductImplBase 
                          implements ActivatableObject {

   public ProductInfo[] getProducts(int pageno) throws SQLError {
     try {
       Vector vector = new Vector();
       ProdIterator iter;
       #sql prodit = { select id, name, price from products
                       where page = :pageno };
       while (iter.next() ) {
         vector.addElement( new ProductInfo (iter.id(),
                                             iter.name(),
                                             iter.price()));
       }
       iter.close ();

       ProductInfo[] result = new ProductInfo[vector.size ()];
       vector.copyInto(result);
       return result;
    } catch (SQLException e) {
      throw new SQLError (e.getMessage ());
    }
  }

  public org.omg.CORBA.Object _initializeAuroraObject () {
    return this;
  }
}
