package catalogueServer;

 import catalogue.*;
 import oracle.aurora.jndi.sess_iiop.ServiceCtx;
 import oracle.aurora.AuroraServices.ActivatableObject;
 import javax.naming.*;
 import java.sql.*;
 import java.util.*;

 public class PageImpl extends PageImplBase implements ActivatableObject {

   Product server = null;

   /* code intermediaire */

   public void insertPage(PageInfo page) throws SQLError {
     try {
       if (server == null) {
          Hashtable env = new Hashtable ();
          env.put (Context.URL_PKG_PREFIXES, "oracle.aurora.jndi");
          Context ic = new InitialContext(env);
          server = (Product) ic.lookup("sess_iiop://thisSession/test/product");
       }

       server.insertProducts( page.pageno, page.products);

       String id   = page.pageno;
       String name = page.description;
       #sql {insert into pages (id,name) values (:id,:name) };

    } catch (SQLException e) {
      throw new SQLError (e.getMessage ());
    } catch (NamingException e) {
      throw new SQLError ("Naming Exception: " + e.getMessage ());
    } 
  }
}
