<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <xsl:template match="/">
    <html>
      <head>
	<link rel="stylesheet" type="text/css" href="rowcol.css" />
      </head>
      <body class="page">
        <CENTER><xsl:apply-templates/></CENTER>  
      </body>
    </html>
  </xsl:template>

  <xsl:template match="xsql-status">
    <B><xsl:value-of select="@rows" /> Row(s) enregistres</B>
    <HR/>
  </xsl:template>

  <xsl:template match="xsql-error">
    <B>Error : <xsl:value-of select="./message" /></B>
    <HR/>
  </xsl:template>


  <xsl:template match="data">
    <TABLE BORDER="0" CELLPADDING="5" CELLSPACING="0">
      <xsl:apply-templates/>  
    </TABLE>
  </xsl:template>


  <xsl:template match="ROW">
    <TR>
      <xsl:attribute name="class">
        <xsl:choose>
          <xsl:when test="position() mod 2 = 1">rowodd</xsl:when>
          <xsl:when test="position() mod 2 = 0">roweven</xsl:when>
        </xsl:choose>
      </xsl:attribute>
      <TD><xsl:value-of select="ID" /></TD>
      <TD><A HREF="doc.xsql?id={ID}"><xsl:value-of select="CAPTION" /></A></TD>
      <TD>stylesheet : <xsl:value-of select="STYLESHEET" /></TD>
    </TR>
  </xsl:template>

</xsl:stylesheet>
