
import org.w3c.dom.*;
import oracle.panama.PanamaException;
import oracle.panama.core.LogicalDevice;

public class ExampleTrf implements Transform {

  private String format(Element el) {
    String result = el.getTagName();
    if (result != null && result.length() > 0) { result += ": "; }
    result += el.getFirstChild().getNodeValue();
    return result;
  }

  public String transform(Element element, LogicalDevice device)
         throws PanamaException {
    StringBuffer buf = new StringBuffer();
    NodeList list = element.getElementsByTagName("*");
    Element el;
    String tag;
    boolean newRow = false;
    for (int i = 0; i < list.getLength(); i ++) {
       el = (Element) list.item(i);
       tag = el.getTagName();
       if (tag.equals("SimpleRow")  || tag.equals("SimpleText") 
           tag.equals("SimpleForm") || tag.equals("SimpleMenu"))  {
          newRow = true;
          buf.append("\n");
       } else if (tag.equals("SimpleCol")) {
          if (!newRow) {
             buf.append("\t");
          } else {
             newRow = false;
          }
          buf.append(format(el));
       } else if (tag.equals("SimpleTextItem") ||      
                  tag.equals("SimpleFormItem") ||  
                  tag.equals("SimpleMenuItem"))   {
          if (!newRow) {
             buf.append("\n");
          } else {
             newRow = false;
          }
          buf.append(format(el));
       }
    }
    return buf.toString();
  }

}
