package controller;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import java.util.*;
import javax.naming.*;
import oracle.jbo.*;
import oracle.jbo.server.*;
import oracle.jbo.common.ampool.*;
import order.*;

public class Shop1 extends HttpServlet {
  String module = "mypool";
 
  public void init(ServletConfig config) throws ServletException {
  	super.init(config);
  /* enregistrement d'un ApplicationPool dans le gestionnaire de pool */
  	try {
   		if (!PoolMgr.getInstance().isPoolCreated(module)) {
     			Hashtable env = new Hashtable();
     			env.put(JboContext.INITIAL_CONTEXT_FACTORY, 
             		JboContext.JBO_CONTEXT_FACTORY);
     			env.put(JboContext.DEPLOY_PLATFORM, JboContext.PLATFORM_LOCAL);
     			PoolMgr.getInstance().createPool(module,"order.AppModule", "jdbc:oracle:thin:scott/tiger@localhost:1521:ORA81", env);
   		}
 	} catch(Exception e) {
  		System.out.println("problem with Application Module Pool");
 	}
  }

  public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
  	Row[] rows = null;
  	AppModuleImpl appMod;

  	res.setContentType("text/html");
  	PrintWriter out = new PrintWriter (res.getOutputStream());
  	try {
 /* recuperation d'une instance d'AM (Application module) */
   		appMod = (AppModuleImpl) 
             	PoolMgr.getInstance().getPool(module).checkout();
 /* manipulation de l'AM : liste la premire colonne de " CustomersView */
   		ViewObjectImpl vo = (ViewObjectImpl) appMod.findViewObject("CustomersView");
   		Rowset rs = vo.createRowSet("test");
   		rows = rs.getAllRowsInRange();
   		for (int i=0; i<rows.length; i++)  {
      			out.println(rows[i].getAttribute(1));
   		}
 /* libration de l'AM et retour dans le pool */
   		PoolMgr.getInstance().getPool(module).checkin(appMod);
  	} catch (Exception e) {
     		e.printStackTrace();
  	}
  	out.close();
 }
 
}
