import catalogue.*;
import oracle.aurora.jndi.sess_iiop.ServiceCtx;
import javax.naming.Context;
import javax.naming.InitialContext;
import java.util.Hashtable;

public class Client {

  public static void main (String[] args) throws Exception {
    Hashtable env = new Hashtable ();
    env.put (Context.URL_PKG_PREFIXES, "oracle.aurora.jndi");
    env.put (Context.SECURITY_PRINCIPAL, "ct99");
    env.put (Context.SECURITY_CREDENTIALS, "ct99");
    env.put (Context.SECURITY_AUTHENTICATION, ServiceCtx.NON_SSL_LOGIN);
    Context ic = new InitialContext (env);
    
    Page page = (Page) ic.lookup("sess_iiop://localhost:2222/test/page");
    PageInfo info = page.getPage(2);
    System.out.println ("page : "+ info.pageno +" "+ info.description );

    ProductInfo[] prods = info.products;
    for (int i = 0; i < prods.length; i++) {
       System.out.println (" "+ prods[i].name +" "+ prods[i].price);
    }
  }
}


