CREATE OR REPLACE TYPE emp_type AS OBJECT (
	empno 	NUMBER(4),
	ename   VARCHAR2(10),
	job   	VARCHAR2(9),
	sal   	NUMBER(7,2),
	comm   	NUMBER(7,2)
);

CREATE TYPE emps_type AS TABLE OF emp_type;

CREATE TYPE dept_type AS OBJECT (
 	deptno  NUMBER(2),
 	dname   VARCHAR2(14),
 	loc     VARCHAR2(13),
 	emps	EMPS_TYPE
);


CREATE TABLE obj_dept OF dept_type
  NESTED TABLE emps STORE AS nested_emp_table;


CREATE VIEW v_dept OF dept_type WITH OBJECT OID(deptno) AS
SELECT  d.deptno, d.dname, d.loc,
        CAST( MULTISET( SELECT  e.empno, e.ename, e.job,e.sal
	              FROM emp e WHERE e.deptno = d.deptno)
	    AS emps_type )
FROM dept d;


CREATE OR REPLACE TRIGGER ins_v_dept INSTEAD OF INSERT ON v_dept
DECLARE
   deptno     NUMBER(2);
   employes   emps_type;
   e 	    emp_type;
BEGIN
   deptno   := :NEW.deptno;
   employes := :NEW.emps;
   INSERT INTO dept ( deptno, dname, loc) 
	VALUES ( deptno, :NEW.dname, :NEW.loc);

   FOR i IN employes.FIRST..employes.LAST LOOP
      e := employes(i);
      INSERT INTO emp  (deptno, empno, ename, job, sal, comm) VALUES
        ( deptno, e.empno, e.ename, e.job, e.sal, e.comm);
   END LOOP;
END;


