import java.io.*;
import java.net.*;
import java.util.*;
import javax.ejb.*;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import oracle.aurora.jndi.sess_iiop.ServiceCtx;

import org.w3c.dom.*;
import org.xml.sax.InputSource;
import oracle.panama.*;
import oracle.panama.ServiceRequest;
import oracle.panama.adapter.*;
import oracle.panama.core.util.XMLUtil;
import oracle.panama.core.xml.XML;
import oracle.panama.core.admin.L;
import oracle.panama.core.parm.PanamaSession;

import oracle.xml.parser.v2.*;

public class EJBAdapter implements Adapter {

 private DOMParser parser;
 private boolean initialized = false;

 public final static boolean TRACE = true;
 public static String USERNAME = "username";
 public static String PASSWORD = "password";
 public static String JNDIPATH = "jndipath";
 public static String ACTION   = "action";
 public static String EJBTYPE  = "ejbtype";

 public Hashtable env;
 public static Class  ejbclass;
 public static Object ejbobject;


// mthode invoque  linitialisation de lAdapter.

 public void init (Arguments args) throws AdapterException {
   synchronized (this) {
     initialized = true;
     parser = new DOMParser();

     USERNAME = args.getInputValue("username");
     PASSWORD = args.getInputValue("password");
     JNDIPATH = args.getInputValue("jndipath");
     EJBTYPE  = args.getInputValue("ejbtype");

     env = new Hashtable();
     env.put(javax.naming.Context.URL_PKG_PREFIXES, "oracle.aurora.jndi");
     env.put(javax.naming.Context.SECURITY_PRINCIPAL, USERNAME);
     env.put(javax.naming.Context.SECURITY_CREDENTIALS, PASSWORD);
     env.put(javax.naming.Context.SECURITY_AUTHENTICATION, ServiceCtx.NON_SSL_LOGIN);

     if ( EJBTYPE.equals("stateless") ) {
        ejbobject = createEJObject();
     }
   }
 }

/* mthode permettant de retrouver la Home interface de lEJB et de crer 
   un EJB Object correspondant  lEJB demand. 
*/

 private Object createEJObject()  {
   Object instance = null;
   try {
      Context ic = new InitialContext(env);
      Object ejbhome = ic.lookup(JNDIPATH);
      Class  ejbhomeclass = ejbhome.getClass();

      java.lang.reflect.Method method = 
					ejbhomeclass.getDeclaredMethod( "create", new Class[0]);

      instance = method.invoke( ejbhome, new Object[0]);

      ejbclass =  ejbobject.getClass();
   } catch (Exception ex) {}
   return  instance;
 }


/* mthode invoque par lappel  lAdapter. Rcupration du paramtre   
   ACTION correspondant  la mthode appele sur lEJB. Linvocation de la 
   dite mthode seffectue par appel dynamique aprs reconstruction des 
   paramtres effectu par la classe XMLRequest ( ci-aprs ). 
*/

 public Element invoke (ServiceRequest sr) throws AdapterException {
   String response;
   XMLDocument result = null;

   try {
      ACTION = sr.getArguments().getInputValue("action");

      XMLRequest xmlrequest = new XMLRequest();
      parser.parse(ACTION);
      xmlrequest.setRequest(parser.getDocument());

      if ( EJBTYPE.equals("stateful") )  {
         ejbobject = sr.getPanamaSession().getValue("myobject");
         if ( ejbobject == null ) {
            ejbobject = createEJObject();
            sr.getPanamaSession().putValue( "myobject", ejbobject);
         }
      }

      java.lang.reflect.Method method = 
				ejbclass.getDeclaredMethod( xmlrequest.getMethodName(), 
													  xmlrequest.getParameters() );

      response = (String) method.invoke( ejbobject, 
													 xmlrequest.getParameterValues());

      parser.parse(response);
      result = parser.getDocument();

   } catch (Exception ex) {
     System.err.println(ex.toString());
     throw new RuntimeException(ex.toString());
   }
   return result.getDocumentElement();
 }


// dfinition des paramtres dinitialisation de lAdapter

 private AdapterDefinition initDef = null;

 public AdapterDefinition getInitDefinition() {
   if (initDef == null) {
    synchronized (this) {
     if (initDef == null) {
      initDef = AdapterHelper.createAdapterDefinition();
      initDef.createInit(Argument.SINGLE_LINE,USERNAME,"username",null);
      initDef.createInit(Argument.SINGLE_LINE,PASSWORD,"password",null);
      initDef.createInit(Argument.SINGLE_LINE,JNDIPATH,"jndipath",null);
      initDef.createInit(Argument.SINGLE_LINE,EJBTYPE,"ejbtype",null );
     }
    }
   }
   return initDef;
 }


// Dfinition des paramtres dentre associs  lappel du service

 private AdapterDefinition adpDef = null;

 public AdapterDefinition getAdapterDefinition() throws AdapterException {
   if (adpDef == null ) {
    synchronized (this) {
     if (adpDef == null) {
      if (initDef == null) throw new AdapterException("Adapter Problem");
      adpDef = initDef;
      adpDef.createInput(Argument.SINGLE_LINE,ACTION,"Method",null);
     }
    }
   }
   return adpDef;
 }

}


