import java.io.*;
import org.w3c.dom.*;
import oracle.xml.parser.v2.*;

public class XMLRequest {

  private XMLDocument doc = null;

  public XMLRequest() {}

  public void setRequest(XMLDocument doc) { this.doc = doc; }

// retrouve dans le flux XML le nom de la mthode  invoquer.

  public String getMethodName() {
    String result;
    NodeList nl = doc.getElementsByTagName("METHOD");
    result = nl.item(0).getFirstChild().getNodeValue();
    return result;
  }

// construit la liste des types de paramtres attendus par la mthode.

  public Class[] getParameters() {
    Class[] result = null;
    try {
       String type;
       NodeList nl = doc.getElementsByTagName("PARAMETER");
       result = new Class[nl.getLength()];
       for ( int i=0; i<nl.getLength(); i++) {
         type  = ((Element)  
                   nl.item(i)).getAttributeNode("type").getNodeValue();
         result[i] = Class.forName(type);
       }
    } catch(Exception e) {}
    return result;
  }

// construit la liste des paramtres passs  la mthode.

  public Object[] getParameterValues() {
    Object[] result;
    Element el;
    String id, type, value;
    NodeList nl = doc.getElementsByTagName("PARAMETER");
    result = new Object[nl.getLength()];
    for ( int i=0; i<nl.getLength(); i++) {
      el = (Element) nl.item(i);
      type  = el.getAttributeNode("type").getNodeValue();
      value = el.getFirstChild().getNodeValue();
      result[i] = getParameterValue( type, value);
    }
    return result;
  }

// reconstruit lobjet correspond au type et  la valeur indiqus.

  private Object getParameterValue(String type, String value) {
    Object result = null;
    try {
      Class aclass = Class.forName(type);
      java.lang.reflect.Constructor constructor = 
          aclass.getConstructor( new Class[] { java.lang.String.class } );
      result = constructor.newInstance( new Object[] { value });
    } catch(Exception e) {}
    return result;
  }
}
