Package catalogue;

#sql iterator ProdIter (int id, String name, double price);

public class PageBean implements EntityBean {
   EntityContext ctx;
   String pageid;
   String description;
   Vector prods;

   Public pageBean() {}
   
   public String getPageId() {
     return pageid;
   }
   
   public String getDescription() throws RemoteException {
     return description;
   } 
   
   public void setDescription(String description) throws RemoteException {
     this.description = description;
   }  
   
   public Vector getProducts() {
     return prods;
   } 
 
   public String ejbCreate() throws CreateException, RemoteException {
     pageid = null;
     try {
        #sql { select pageseq.nextval into :pageid from dual };
        #sql { insert into pages ( id ) values ( :pageid ) };       
     } catch (SQLException e) {
        throw new PageException (this, "create", e);
     }
     return pageid;
   }

   public void ejbPostCreate() {
     prods = new Vector ();
   }

   public String ejbFindByPrimaryKey(String id) throws FinderException, RemoteException {
     try {
        int count;
        #sql { select count(id) into :count from pages where id = :id };

        if (count != 1) throw new FinderException("no Page: " + id);
     } catch (SQLException e) {
        throw new PageException (this, "findByPrimaryKey", e);
     }
     return id;
   }

  public void ejbStore() throws RemoteException {
    pageid = (String) ctx.getPrimaryKey();
    try {
      #sql { update pages description = :description where id = :pageid };
      #sql { delete from products where page = :pageid };
      Enumeration e = items.elements ();
      while (e.hasMoreElements ()) {
         Product prod = (Product) e.nextElement();
         #sql { insert into products (page, id, name, price)
                values (:pageid,:(prod.id),:(prod.name),:(prod.price))};
      }
    } catch (SQLException e) {
      throw new PageException (this, "store", e);
    }
  }

  public void ejbLoad() throws RemoteException {
    pageid = (String) ctx.getPrimaryKey();
    try {
      prods = new Vector();
      ProdIter iter = null;
      try {
        #sql { select description into :description from pages where id = :pageid };
        #sql iter = { select id, name, price from products where page = :pageid };
        while (iter.next ()) {
          Product prod = new Product( iter.id(),
				      iter.name(),
				      iter.price());
          prods.addElement (prod);
        }
      } finally {
        if (iter != null) iter.close ();
      }
    } catch (SQLException e) {
      throw new PageException (this, "load", e);
    }
  }

  public void ejbRemove() throws RemoteException {
    pageid = (String) ctx.getPrimaryKey();
    try {
      #sql { delete from products where page = :pageid };
      #sql { delete from pages where id = :pageid };
    } catch (SQLException e) {
      throw new PageException (this, "remove", e);
    }
  }

  public void setEntityContext(EntityContext ctx) {
    this.ctx = ctx;
  }
  
  public void unsetEntityContext() {
    this.ctx = null;
  }

  public void ejbActivate() {}

  public void ejbPassivate() {}

}





